/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.models.ResourceImpl;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.commands.updateactions.ChangeName;
import io.sphere.sdk.shoppinglists.commands.updateactions.SetAnonymousId;
import io.sphere.sdk.shoppinglists.commands.updateactions.SetCustomer;
import io.sphere.sdk.shoppinglists.commands.updateactions.SetDeleteDaysAfterLastModification;
import io.sphere.sdk.shoppinglists.commands.updateactions.SetDescription;
import io.sphere.sdk.shoppinglists.commands.updateactions.SetSlug;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ShoppingListUpdateActionUtils {
    private ShoppingListUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildSetSlugUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getSlug(), newShoppingList.getSlug(), () -> SetSlug.of((LocalizedString)newShoppingList.getSlug()));
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildChangeNameUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getName(), newShoppingList.getName(), () -> ChangeName.of((LocalizedString)newShoppingList.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildSetDescriptionUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getDescription(), newShoppingList.getDescription(), () -> SetDescription.of((LocalizedString)newShoppingList.getDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildSetCustomerUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldShoppingList.getCustomer(), newShoppingList.getCustomer(), () -> SetCustomer.of(ShoppingListUpdateActionUtils.mapResourceIdentifierToReferenceable((ResourceIdentifier<Customer>)newShoppingList.getCustomer())));
    }

    @Nullable
    private static Referenceable<Customer> mapResourceIdentifierToReferenceable(final @Nullable ResourceIdentifier<Customer> resourceIdentifier) {
        if (resourceIdentifier == null) {
            return null;
        }
        return new ResourceImpl<Customer>(null, null, null, null){

            public Reference<Customer> toReference() {
                return Reference.of((String)Customer.referenceTypeId(), (String)resourceIdentifier.getId());
            }
        };
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildSetAnonymousIdUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getAnonymousId(), newShoppingList.getAnonymousId(), () -> SetAnonymousId.of((String)newShoppingList.getAnonymousId()));
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildSetDeleteDaysAfterLastModificationUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getDeleteDaysAfterLastModification(), newShoppingList.getDeleteDaysAfterLastModification(), () -> SetDeleteDaysAfterLastModification.of((Integer)newShoppingList.getDeleteDaysAfterLastModification()));
    }
}

