/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.taxcategories;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.impl.TaxCategoryServiceImpl;
import com.commercetools.sync.taxcategories.TaxCategorySyncOptions;
import com.commercetools.sync.taxcategories.helpers.TaxCategoryBatchValidator;
import com.commercetools.sync.taxcategories.helpers.TaxCategorySyncStatistics;
import com.commercetools.sync.taxcategories.utils.TaxCategorySyncUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.taxcategories.TaxCategory;
import io.sphere.sdk.taxcategories.TaxCategoryDraft;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TaxCategorySync
extends BaseSync<TaxCategoryDraft, TaxCategorySyncStatistics, TaxCategorySyncOptions> {
    private static final String TAX_CATEGORY_FETCH_FAILED = "Failed to fetch existing tax categories with keys: '%s'.";
    private static final String TAX_CATEGORY_UPDATE_FAILED = "Failed to update tax category with key: '%s'. Reason: %s";
    private final TaxCategoryService taxCategoryService;
    private final TaxCategoryBatchValidator batchValidator;

    public TaxCategorySync(@Nonnull TaxCategorySyncOptions taxCategorySyncOptions) {
        this(taxCategorySyncOptions, new TaxCategoryServiceImpl(taxCategorySyncOptions));
    }

    TaxCategorySync(@Nonnull TaxCategorySyncOptions taxCategorySyncOptions, @Nonnull TaxCategoryService taxCategoryService) {
        super(new TaxCategorySyncStatistics(), taxCategorySyncOptions);
        this.taxCategoryService = taxCategoryService;
        this.batchValidator = new TaxCategoryBatchValidator((TaxCategorySyncOptions)this.getSyncOptions(), (TaxCategorySyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<TaxCategorySyncStatistics> process(@Nonnull List<TaxCategoryDraft> resourceDrafts) {
        List batches = SyncUtils.batchElements(resourceDrafts, ((TaxCategorySyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<TaxCategorySyncStatistics> processBatch(@Nonnull List<TaxCategoryDraft> batch) {
        ImmutablePair<Set<TaxCategoryDraft>, Set<String>> result = this.batchValidator.validateAndCollectReferencedKeys(batch);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((TaxCategorySyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        Set validTaxCategoryKeys = (Set)result.getRight();
        return this.taxCategoryService.fetchMatchingTaxCategoriesByKeys(validTaxCategoryKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedTaxCategories = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(TAX_CATEGORY_FETCH_FAILED, validTaxCategoryKeys);
                this.handleError(new SyncException(errorMessage, exception), null, null, null, validTaxCategoryKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(fetchedTaxCategories, validDrafts);
        }).thenApply(ignored -> {
            ((TaxCategorySyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (TaxCategorySyncStatistics)this.statistics;
        });
    }

    private void handleError(@Nonnull SyncException syncException, @Nullable TaxCategory entry, @Nullable TaxCategoryDraft draft, @Nullable List<UpdateAction<TaxCategory>> updateActions, int failedTimes) {
        ((TaxCategorySyncOptions)this.syncOptions).applyErrorCallback(syncException, entry, draft, updateActions);
        ((TaxCategorySyncStatistics)this.statistics).incrementFailed(failedTimes);
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<TaxCategory> oldTaxCategories, @Nonnull Set<TaxCategoryDraft> newTaxCategories) {
        Map oldTaxCategoryMap = oldTaxCategories.stream().collect(Collectors.toMap(TaxCategory::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newTaxCategories.stream().map(newTaxCategory -> {
            TaxCategory oldTaxCategory = (TaxCategory)oldTaxCategoryMap.get(newTaxCategory.getKey());
            return Optional.ofNullable(oldTaxCategory).map(taxCategory -> this.buildActionsAndUpdate(oldTaxCategory, (TaxCategoryDraft)newTaxCategory)).orElseGet(() -> this.applyCallbackAndCreate((TaxCategoryDraft)newTaxCategory));
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Optional<TaxCategory>> applyCallbackAndCreate(@Nonnull TaxCategoryDraft taxCategoryDraft) {
        return ((TaxCategorySyncOptions)this.syncOptions).applyBeforeCreateCallback(taxCategoryDraft).map(draft -> this.taxCategoryService.createTaxCategory((TaxCategoryDraft)draft).thenApply(taxCategoryOptional -> {
            if (taxCategoryOptional.isPresent()) {
                ((TaxCategorySyncStatistics)this.statistics).incrementCreated();
            } else {
                ((TaxCategorySyncStatistics)this.statistics).incrementFailed();
            }
            return taxCategoryOptional;
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Optional<TaxCategory>> buildActionsAndUpdate(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        List updateActions = TaxCategorySyncUtils.buildActions(oldTaxCategory, newTaxCategory);
        List<UpdateAction<TaxCategory>> updateActionsAfterCallback = ((TaxCategorySyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newTaxCategory, oldTaxCategory);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateTaxCategory(oldTaxCategory, newTaxCategory, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Optional<TaxCategory>> updateTaxCategory(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory, @Nonnull List<UpdateAction<TaxCategory>> updateActions) {
        return this.taxCategoryService.updateTaxCategory(oldTaxCategory, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            TaxCategory updatedTaxCategory = (TaxCategory)updateResponse.getKey();
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return TaxCategorySync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldTaxCategory, newTaxCategory), () -> {
                    String errorMessage = String.format(TAX_CATEGORY_UPDATE_FAILED, newTaxCategory.getKey(), sphereException.getMessage());
                    this.handleError(new SyncException(errorMessage, sphereException), oldTaxCategory, newTaxCategory, updateActions, 1);
                    return CompletableFuture.completedFuture(Optional.empty());
                });
            }
            ((TaxCategorySyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(Optional.of(updatedTaxCategory));
        });
    }

    @Nonnull
    private CompletionStage<Optional<TaxCategory>> fetchAndUpdate(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        String key = oldTaxCategory.getKey();
        return this.taxCategoryService.fetchTaxCategory(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedTaxCategoryOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(TAX_CATEGORY_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(new SyncException(errorMessage, exception), oldTaxCategory, newTaxCategory, null, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedTaxCategoryOptional.map(fetchedTaxCategory -> this.buildActionsAndUpdate((TaxCategory)fetchedTaxCategory, newTaxCategory)).orElseGet(() -> {
                String errorMessage = String.format(TAX_CATEGORY_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(new SyncException(errorMessage), oldTaxCategory, newTaxCategory, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }
}

