/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryBatchValidator;
import com.commercetools.sync.categories.helpers.CategoryReferenceResolver;
import com.commercetools.sync.categories.helpers.CategorySyncStatistics;
import com.commercetools.sync.categories.utils.CategorySyncUtils;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.models.WaitingToBeResolvedCategories;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.commons.utils.ResourceIdentifierUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.UnresolvedReferencesService;
import com.commercetools.sync.services.impl.CategoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import com.commercetools.sync.services.impl.UnresolvedReferencesServiceImpl;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.CategoryDraftBuilder;
import io.sphere.sdk.commands.UpdateAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CategorySync
extends BaseSync<CategoryDraft, CategorySyncStatistics, CategorySyncOptions> {
    private static final String FAILED_TO_PROCESS = "Failed to process the CategoryDraft with key: '%s'. Reason: %s";
    private static final String UPDATE_FAILED = "Failed to update Category with key: '%s'. Reason: %s";
    private static final String FAILED_TO_FETCH_WAITING_DRAFTS = "Failed to fetch CategoryDraft waiting to be resolved with parent keys: '%s'.";
    private final CategoryService categoryService;
    private final UnresolvedReferencesService<WaitingToBeResolvedCategories> unresolvedReferencesService;
    private final CategoryReferenceResolver referenceResolver;
    private final CategoryBatchValidator batchValidator;
    private final ConcurrentHashMap.KeySetView<String, Boolean> processedCategoryKeys = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<CategoryDraft, Category> categoryDraftsToUpdate = new ConcurrentHashMap();
    private final Set<CategoryDraft> referencesResolvedDrafts = new HashSet<CategoryDraft>();

    public CategorySync(@Nonnull CategorySyncOptions syncOptions) {
        this(syncOptions, new TypeServiceImpl(syncOptions), new CategoryServiceImpl(syncOptions), new UnresolvedReferencesServiceImpl<WaitingToBeResolvedCategories>(syncOptions));
    }

    CategorySync(@Nonnull CategorySyncOptions syncOptions, @Nonnull TypeService typeService, @Nonnull CategoryService categoryService, @Nonnull UnresolvedReferencesService<WaitingToBeResolvedCategories> unresolvedReferencesService) {
        super(new CategorySyncStatistics(), syncOptions);
        this.categoryService = categoryService;
        this.unresolvedReferencesService = unresolvedReferencesService;
        this.referenceResolver = new CategoryReferenceResolver((CategorySyncOptions)this.getSyncOptions(), typeService, categoryService);
        this.batchValidator = new CategoryBatchValidator((CategorySyncOptions)this.getSyncOptions(), (CategorySyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<CategorySyncStatistics> process(@Nonnull List<CategoryDraft> categoryDrafts) {
        List batches = SyncUtils.batchElements(categoryDrafts, ((CategorySyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<CategorySyncStatistics> processBatch(@Nonnull List<CategoryDraft> categoryDrafts) {
        this.categoryDraftsToUpdate = new ConcurrentHashMap();
        int numberOfNewDraftsToProcess = this.getNumberOfDraftsToProcess(categoryDrafts);
        ImmutablePair<Set<CategoryDraft>, CategoryBatchValidator.ReferencedKeys> result = this.batchValidator.validateAndCollectReferencedKeys(categoryDrafts);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((CategorySyncStatistics)this.statistics).incrementProcessed(categoryDrafts.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        return ((CompletableFuture)((CompletableFuture)this.referenceResolver.populateKeyToIdCachesForReferencedKeys((CategoryBatchValidator.ReferencedKeys)result.getRight()).handle(ImmutablePair::new)).thenCompose(cachingResponse -> {
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError(new SyncException("Failed to build a cache of keys to ids.", cachingException), validDrafts.size());
                return CompletableFuture.completedFuture(null);
            }
            Map categoryKeyToIdCache = (Map)cachingResponse.getKey();
            return this.createAndUpdate(this.prepareDraftsForProcessing(new ArrayList<CategoryDraft>(validDrafts), categoryKeyToIdCache), categoryKeyToIdCache);
        })).thenApply(ignoredResult -> {
            ((CategorySyncStatistics)this.statistics).incrementProcessed(numberOfNewDraftsToProcess);
            return (CategorySyncStatistics)this.statistics;
        });
    }

    private int getNumberOfDraftsToProcess(@Nonnull List<CategoryDraft> categoryDrafts) {
        long numberOfNullCategoryDrafts = categoryDrafts.stream().filter(Objects::isNull).count();
        long numberOfCategoryDraftsNotProcessedBefore = categoryDrafts.stream().filter(Objects::nonNull).map(CategoryDraft::getKey).filter(categoryDraftKey -> categoryDraftKey == null || !this.processedCategoryKeys.contains(categoryDraftKey)).count();
        return (int)(numberOfCategoryDraftsNotProcessedBefore + numberOfNullCategoryDrafts);
    }

    private CompletionStage<Void> fetchAndUpdate(@Nonnull Set<CategoryDraft> existingCategories, @Nonnull Map<String, String> keyToIdCache) {
        Set<String> categoryKeysToFetch = existingCategories.stream().map(CategoryDraft::getKey).collect(Collectors.toSet());
        return this.categoryService.fetchMatchingCategoriesByKeys(categoryKeysToFetch).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedCategories = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format("Failed to fetch existing categories with keys: '%s'.", categoryKeysToFetch);
                this.handleError(new SyncException(errorMessage, exception), categoryKeysToFetch.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.processFetchedCategoriesAndUpdate(keyToIdCache, fetchedCategories);
        });
    }

    @Nonnull
    private CompletionStage<Void> processFetchedCategoriesAndUpdate(@Nonnull Map<String, String> keyToIdCache, @Nonnull Set<Category> fetchedCategories) {
        this.processFetchedCategories(fetchedCategories, this.referencesResolvedDrafts, keyToIdCache);
        this.updateCategoriesSequentially(this.categoryDraftsToUpdate);
        return this.updateCategoriesInParallel(this.categoryDraftsToUpdate);
    }

    private ImmutablePair<Set<CategoryDraft>, Set<CategoryDraft>> prepareDraftsForProcessing(@Nonnull List<CategoryDraft> categoryDrafts, @Nonnull Map<String, String> keyToIdCache) {
        HashSet existingCategoryDrafts = new HashSet();
        HashSet newCategoryDrafts = new HashSet();
        for (CategoryDraft draft : categoryDrafts) {
            String categoryKey = draft.getKey();
            try {
                this.checkParentCategoriesAndKeepTrack(draft, keyToIdCache).ifPresent(categoryDraft -> this.referenceResolver.resolveReferences((CategoryDraft)categoryDraft).thenAccept(referencesResolvedDraft -> {
                    this.referencesResolvedDrafts.add((CategoryDraft)referencesResolvedDraft);
                    if (keyToIdCache.containsKey(categoryKey)) {
                        existingCategoryDrafts.add(referencesResolvedDraft);
                    } else {
                        newCategoryDrafts.add(referencesResolvedDraft);
                    }
                }).exceptionally(completionException -> {
                    String errorMessage = String.format(FAILED_TO_PROCESS, categoryKey, completionException.getMessage());
                    this.handleError(errorMessage, (Throwable)completionException);
                    return null;
                }).toCompletableFuture().join());
            }
            catch (Exception exception) {
                String errorMessage = String.format(FAILED_TO_PROCESS, categoryKey, exception);
                this.handleError(errorMessage, exception);
            }
        }
        return ImmutablePair.of(newCategoryDrafts, existingCategoryDrafts);
    }

    @Nonnull
    private CompletionStage<Void> createAndUpdate(ImmutablePair<Set<CategoryDraft>, Set<CategoryDraft>> preparedDraftsForProcessing, @Nonnull Map<String, String> keyToIdCache) {
        return this.createCategories((Set)preparedDraftsForProcessing.getLeft()).thenAccept(createdCategories -> this.processCreatedCategories((Set<Category>)createdCategories, keyToIdCache)).thenCompose(ignoredResult -> this.fetchAndUpdate((Set)preparedDraftsForProcessing.getRight(), keyToIdCache));
    }

    @Nonnull
    private CompletionStage<Set<Category>> createCategories(@Nonnull Set<CategoryDraft> categoryDrafts) {
        return ((CompletableFuture)CompletableFutureUtils.mapValuesToFutureOfCompletedValues(categoryDrafts, this::applyCallbackAndCreate).thenApply(results -> results.filter(Optional::isPresent).map(Optional::get))).thenApply(result -> {
            Set createdCategories = result.collect(Collectors.toSet());
            ((CategorySyncStatistics)this.statistics).incrementCreated(createdCategories.size());
            int numberOfFailedCategories = categoryDrafts.size() - createdCategories.size();
            if (numberOfFailedCategories > 0) {
                ((CategorySyncStatistics)this.statistics).incrementFailed(numberOfFailedCategories);
            }
            return createdCategories;
        });
    }

    @Nonnull
    private CompletionStage<Optional<Category>> applyCallbackAndCreate(@Nonnull CategoryDraft categoryDraft) {
        return ((CategorySyncOptions)this.syncOptions).applyBeforeCreateCallback(categoryDraft).map(this.categoryService::createCategory).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    private Optional<CategoryDraft> checkParentCategoriesAndKeepTrack(@Nonnull CategoryDraft categoryDraft, @Nonnull Map<String, String> keyToIdCache) throws ReferenceResolutionException {
        String parentCategoryKey = CategoryReferenceResolver.getParentCategoryKey(categoryDraft).orElse("");
        if (StringUtils.isBlank((CharSequence)parentCategoryKey) || !this.isMissingCategory(parentCategoryKey, keyToIdCache)) {
            return Optional.of(categoryDraft);
        }
        this.unresolvedReferencesService.save(new WaitingToBeResolvedCategories(categoryDraft, Collections.singleton(parentCategoryKey)), "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", WaitingToBeResolvedCategories.class).toCompletableFuture().join();
        ((CategorySyncStatistics)this.statistics).putMissingParentCategoryChildKey(parentCategoryKey, categoryDraft.getKey());
        return Optional.empty();
    }

    private boolean isMissingCategory(@Nonnull String categoryKey, @Nonnull Map<String, String> keyToIdCache) {
        return !keyToIdCache.containsKey(categoryKey);
    }

    private void processCreatedCategories(@Nonnull Set<Category> createdCategories, @Nonnull Map<String, String> keyToIdCache) {
        if (!createdCategories.isEmpty()) {
            Set<String> resolvedParentKeys = createdCategories.stream().map(c -> c.getKey()).collect(Collectors.toSet());
            this.fetchResolvableCategories(resolvedParentKeys).thenAccept(readyToSync -> {
                if (!readyToSync.isEmpty()) {
                    ImmutablePair<Set<CategoryDraft>, Set<CategoryDraft>> preparedDraft = this.prepareDraftsForProcessing((List<CategoryDraft>)readyToSync, keyToIdCache);
                    this.createAndUpdate(preparedDraft, keyToIdCache).toCompletableFuture().join();
                    this.removeFromWaiting(readyToSync.stream().filter(c -> keyToIdCache.containsKey(c.getKey())).collect(Collectors.toList()));
                }
            }).toCompletableFuture().join();
        }
    }

    @Nonnull
    private CompletionStage<List<CategoryDraft>> fetchResolvableCategories(Set<String> resolvedParent) {
        ArrayList readyToSync = new ArrayList();
        Set<String> resolvableCategoryKeys = resolvedParent.stream().map(((CategorySyncStatistics)this.statistics)::removeAndGetChildrenKeys).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        if (resolvableCategoryKeys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.unresolvedReferencesService.fetch(resolvableCategoryKeys, "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", WaitingToBeResolvedCategories.class).handle(ImmutablePair::new).thenApply(fetchResponse -> {
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(FAILED_TO_FETCH_WAITING_DRAFTS, String.join((CharSequence)",", resolvableCategoryKeys.toString()));
                this.handleError(new SyncException(errorMessage, fetchException), 1);
                return readyToSync;
            }
            Set waitingDrafts = (Set)fetchResponse.getKey();
            waitingDrafts.forEach(draft -> {
                CategoryDraft categoryDraft = draft.getCategoryDraft();
                readyToSync.add(categoryDraft);
            });
            return readyToSync;
        });
    }

    private void removeFromWaiting(@Nonnull List<CategoryDraft> drafts) {
        CompletableFuture.allOf((CompletableFuture[])drafts.stream().map(CategoryDraft::getKey).map(key -> this.unresolvedReferencesService.delete((String)key, "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", WaitingToBeResolvedCategories.class)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)).toCompletableFuture().join();
    }

    private void processFetchedCategories(@Nonnull Set<Category> fetchedCategories, @Nonnull Set<CategoryDraft> resolvedReferencesDrafts, @Nonnull Map<String, String> keyToIdCache) {
        fetchedCategories.forEach(fetchedCategory -> {
            String fetchedCategoryKey = fetchedCategory.getKey();
            Optional<CategoryDraft> draftByKeyIfExists = CategorySync.getDraftByKeyIfExists(resolvedReferencesDrafts, fetchedCategoryKey);
            CategoryDraftBuilder categoryDraftBuilder = draftByKeyIfExists.map(categoryDraft -> {
                if (categoryDraft.getParent() == null) {
                    return (CategoryDraftBuilder)CategoryDraftBuilder.of((CategoryDraft)categoryDraft).parent(ResourceIdentifierUtils.toResourceIdentifierIfNotNull(fetchedCategory.getParent()));
                }
                return CategoryDraftBuilder.of((CategoryDraft)categoryDraft);
            }).orElseGet(() -> CategoryDraftBuilder.of((Category)fetchedCategory));
            this.categoryDraftsToUpdate.put((CategoryDraft)categoryDraftBuilder.build(), (Category)fetchedCategory);
        });
    }

    private static Optional<CategoryDraft> getDraftByKeyIfExists(@Nonnull Set<CategoryDraft> categoryDrafts, @Nonnull String key) {
        return categoryDrafts.stream().filter(categoryDraft -> Objects.equals(categoryDraft.getKey(), key)).findFirst();
    }

    private void updateCategoriesSequentially(@Nonnull Map<CategoryDraft, Category> matchingCategories) {
        matchingCategories.entrySet().stream().filter(entry -> CategorySync.requiresChangeParentUpdateAction((Category)entry.getValue(), (CategoryDraft)entry.getKey())).map(entry -> this.buildUpdateActionsAndUpdate((Category)entry.getValue(), (CategoryDraft)entry.getKey())).map(CompletionStage::toCompletableFuture).forEach(CompletableFuture::join);
    }

    static boolean requiresChangeParentUpdateAction(@Nonnull Category category, @Nonnull CategoryDraft categoryDraft) {
        return !CommonTypeUpdateActionUtils.areResourceIdentifiersEqual(category.getParent(), categoryDraft.getParent());
    }

    private CompletionStage<Void> updateCategoriesInParallel(@Nonnull Map<CategoryDraft, Category> matchingCategories) {
        List<CompletableFuture> futures = matchingCategories.entrySet().stream().filter(entry -> !CategorySync.requiresChangeParentUpdateAction((Category)entry.getValue(), (CategoryDraft)entry.getKey())).map(entry -> this.buildUpdateActionsAndUpdate((Category)entry.getValue(), (CategoryDraft)entry.getKey())).map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    private CompletionStage<Void> buildUpdateActionsAndUpdate(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        List updateActions = CategorySyncUtils.buildActions(oldCategory, newCategory, (CategorySyncOptions)this.syncOptions);
        List<UpdateAction<Category>> beforeUpdateCallBackApplied = ((CategorySyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newCategory, oldCategory);
        if (!beforeUpdateCallBackApplied.isEmpty()) {
            return this.updateCategory(oldCategory, newCategory, beforeUpdateCallBackApplied);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Void> updateCategory(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull List<UpdateAction<Category>> updateActions) {
        String categoryKey = oldCategory.getKey();
        return this.categoryService.updateCategory(oldCategory, updateActions).handle((updatedCategory, sphereException) -> sphereException).thenCompose(sphereException -> {
            if (sphereException != null) {
                return CategorySync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.refetchAndUpdate(oldCategory, newCategory), () -> {
                    if (!this.processedCategoryKeys.contains(categoryKey)) {
                        this.handleError(String.format(UPDATE_FAILED, categoryKey, sphereException), (Throwable)sphereException, oldCategory, newCategory, updateActions);
                        this.processedCategoryKeys.add(categoryKey);
                    }
                    return CompletableFuture.completedFuture(null);
                });
            }
            if (!this.processedCategoryKeys.contains(categoryKey)) {
                ((CategorySyncStatistics)this.statistics).incrementUpdated();
                this.processedCategoryKeys.add(categoryKey);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletionStage<Void> refetchAndUpdate(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        String key = oldCategory.getKey();
        return this.categoryService.fetchCategory(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedCategoryOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, oldCategory, newCategory, null);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedCategoryOptional.map(fetchedCategory -> this.buildUpdateActionsAndUpdate((Category)fetchedCategory, newCategory)).orElseGet(() -> {
                String errorMessage = String.format(UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, oldCategory, newCategory, null);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception) {
        this.handleError(errorMessage, exception, null, null, null);
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, @Nullable Category oldCategory, @Nullable CategoryDraft newCategory, @Nullable List<UpdateAction<Category>> updateActions) {
        SyncException syncException = exception != null ? new SyncException(errorMessage, exception) : new SyncException(errorMessage);
        ((CategorySyncOptions)this.syncOptions).applyErrorCallback(syncException, oldCategory, newCategory, updateActions);
        ((CategorySyncStatistics)this.statistics).incrementFailed();
    }

    private void handleError(@Nonnull SyncException syncException, int failedTimes) {
        ((CategorySyncOptions)this.syncOptions).applyErrorCallback(syncException);
        ((CategorySyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

