/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CategorySyncStatistics
extends BaseSyncStatistics {
    private ConcurrentHashMap<String, Set<String>> categoryKeysWithMissingParents = new ConcurrentHashMap();

    @Override
    public String getReportMessage() {
        return String.format("Summary: %s categories were processed in total (%s created, %s updated, %s failed to sync and %s categories with a missing parent).", this.getProcessed(), this.getCreated(), this.getUpdated(), this.getFailed(), this.getNumberOfCategoriesWithMissingParents());
    }

    public int getNumberOfCategoriesWithMissingParents() {
        return this.categoryKeysWithMissingParents.values().stream().mapToInt(Set::size).sum();
    }

    public Map<String, Set<String>> getCategoryKeysWithMissingParents() {
        return Collections.unmodifiableMap(this.categoryKeysWithMissingParents);
    }

    public void setCategoryKeysWithMissingParents(@Nonnull ConcurrentHashMap<String, Set<String>> categoryKeysWithMissingParents) {
        this.categoryKeysWithMissingParents = categoryKeysWithMissingParents;
    }

    public void putMissingParentCategoryChildKey(@Nonnull String missingParentCategoryKey, @Nonnull String childKey) {
        Set<String> missingParentCategoryChildrenKeys = this.categoryKeysWithMissingParents.get(missingParentCategoryKey);
        if (missingParentCategoryChildrenKeys != null) {
            missingParentCategoryChildrenKeys.add(childKey);
        } else {
            HashSet<String> newChildCategoryKeys = new HashSet<String>();
            newChildCategoryKeys.add(childKey);
            this.categoryKeysWithMissingParents.put(missingParentCategoryKey, newChildCategoryKeys);
        }
    }

    @Nonnull
    public Optional<String> getMissingParentKey(@Nonnull String childCategoryKey) {
        return this.categoryKeysWithMissingParents.entrySet().stream().filter(missingParentEntry -> ((Set)missingParentEntry.getValue()).contains(childCategoryKey)).findFirst().map(Map.Entry::getKey);
    }

    public void removeChildCategoryKeyFromMissingParentsMap(@Nonnull String childCategoryKey) {
        this.categoryKeysWithMissingParents.forEach((key, value) -> value.remove(childCategoryKey));
    }

    @Nullable
    public Set<String> removeAndGetChildrenKeys(@Nonnull String key) {
        return this.categoryKeysWithMissingParents.remove(key);
    }
}

