/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.sync.commons.utils.AssetReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.CategoryDraftBuilder;
import io.sphere.sdk.categories.expansion.CategoryExpansionModel;
import io.sphere.sdk.categories.queries.CategoryQuery;
import io.sphere.sdk.expansion.ExpansionPath;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CategoryReferenceResolutionUtils {
    private CategoryReferenceResolutionUtils() {
    }

    @Nonnull
    public static List<CategoryDraft> mapToCategoryDrafts(@Nonnull List<Category> categories) {
        return categories.stream().map(CategoryReferenceResolutionUtils::mapToCategoryDraft).collect(Collectors.toList());
    }

    @Nonnull
    private static CategoryDraft mapToCategoryDraft(@Nonnull Category category) {
        return ((CategoryDraftBuilder)((CategoryDraftBuilder)((CategoryDraftBuilder)CategoryDraftBuilder.of((Category)category).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(category))).assets(AssetReferenceResolutionUtils.mapToAssetDrafts(category.getAssets()))).parent(SyncUtils.getResourceIdentifierWithKey(category.getParent()))).build();
    }

    public static CategoryQuery buildCategoryQuery() {
        return ((CategoryQuery)((CategoryQuery)((CategoryQuery)CategoryQuery.of().withLimit(500L)).withExpansionPaths(ExpansionPath.of((String)"custom.type"))).plusExpansionPaths(ExpansionPath.of((String)"assets[*].custom.type"))).plusExpansionPaths(CategoryExpansionModel::parent);
    }
}

