/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.QuadConsumer;
import com.commercetools.sync.commons.utils.TriConsumer;
import com.commercetools.sync.commons.utils.TriFunction;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.commands.UpdateAction;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class BaseSyncOptionsBuilder<T extends BaseSyncOptionsBuilder<T, S, U, V>, S extends BaseSyncOptions, U, V> {
    protected SphereClient ctpClient;
    protected QuadConsumer<SyncException, Optional<V>, Optional<U>, List<UpdateAction<U>>> errorCallback;
    protected TriConsumer<SyncException, Optional<V>, Optional<U>> warningCallback;
    protected int batchSize = 30;
    protected TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback;
    protected Function<V, V> beforeCreateCallback;
    protected long cacheSize = 10000L;

    public T errorCallback(@Nonnull QuadConsumer<SyncException, Optional<V>, Optional<U>, List<UpdateAction<U>>> errorCallback) {
        this.errorCallback = errorCallback;
        return this.getThis();
    }

    public T warningCallback(@Nonnull TriConsumer<SyncException, Optional<V>, Optional<U>> warningCallback) {
        this.warningCallback = warningCallback;
        return this.getThis();
    }

    public T batchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
        return this.getThis();
    }

    public T cacheSize(long cacheSize) {
        if (cacheSize > 0L) {
            this.cacheSize = cacheSize;
        }
        return this.getThis();
    }

    public T beforeUpdateCallback(@Nonnull TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback) {
        this.beforeUpdateCallback = beforeUpdateCallback;
        return this.getThis();
    }

    public T beforeCreateCallback(@Nonnull Function<V, V> beforeCreateCallback) {
        this.beforeCreateCallback = beforeCreateCallback;
        return this.getThis();
    }

    protected abstract S build();

    protected abstract T getThis();
}

