/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseReferenceResolver<T, S extends BaseSyncOptions> {
    public static final String BLANK_KEY_VALUE_ON_RESOURCE_IDENTIFIER = "The value of the 'key' field of the Resource Identifier is blank (null/empty). Expecting the key of the referenced resource.";
    public static final String BLANK_ID_VALUE_ON_REFERENCE = "The value of the 'id' field of the Reference is blank (null/empty). Expecting the key of the referenced resource.";
    protected S options;

    protected BaseReferenceResolver(@Nonnull S options) {
        this.options = options;
    }

    public abstract CompletionStage<T> resolveReferences(@Nonnull T var1);

    @Nonnull
    protected static <T> String getIdFromReference(@Nonnull Reference<T> reference) throws ReferenceResolutionException {
        String id = reference.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ReferenceResolutionException(BLANK_ID_VALUE_ON_REFERENCE);
        }
        return id;
    }

    @Nonnull
    protected static <T> String getKeyFromResourceIdentifier(@Nonnull ResourceIdentifier<T> resourceIdentifier) throws ReferenceResolutionException {
        String key = resourceIdentifier.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ReferenceResolutionException(BLANK_KEY_VALUE_ON_RESOURCE_IDENTIFIER);
        }
        return key;
    }
}

