/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.GenericCustomActionBuilder;
import com.commercetools.sync.commons.utils.GenericUpdateActionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.types.Custom;
import io.sphere.sdk.types.CustomDraft;
import io.sphere.sdk.types.CustomFields;
import io.sphere.sdk.types.CustomFieldsDraft;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomUpdateActionUtils {
    private static final String CUSTOM_TYPE_IDS_NOT_SET = "Custom type ids are not set for both the old and new %s.";
    private static final String CUSTOM_FIELDS_UPDATE_ACTIONS_BUILD_FAILED = "Failed to build custom fields update actions on the %s with id '%s'. Reason: %s";
    private static final String CUSTOM_TYPE_ID_IS_BLANK = "New resource's custom type id is blank (empty/null).";

    @Nonnull
    public static <T extends Custom & Resource<T>, S extends CustomDraft> List<UpdateAction<T>> buildPrimaryResourceCustomUpdateActions(@Nonnull T oldResource, @Nonnull S newResource, @Nonnull GenericCustomActionBuilder<T> customActionBuilder, @Nonnull BaseSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(oldResource, newResource, customActionBuilder, null, resource -> ((Resource)resource).getId(), resource -> ((Resource)resource).toReference().getTypeId(), resource -> null, syncOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static <D, T extends Custom, S extends CustomDraft, U extends Resource<U>> List<UpdateAction<U>> buildCustomUpdateActions(@Nullable Resource oldMainResource, @Nullable D newMainResourceDraft, @Nonnull T oldResource, @Nonnull S newResourceDraft, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> resourceIdGetter, @Nonnull Function<T, String> resourceTypeIdGetter, @Nonnull Function<T, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) {
        CustomFields oldResourceCustomFields = oldResource.getCustom();
        CustomFieldsDraft newResourceCustomFields = newResourceDraft.getCustom();
        if (oldResourceCustomFields != null && newResourceCustomFields != null) {
            try {
                return CustomUpdateActionUtils.buildNonNullCustomFieldsUpdateActions(oldResourceCustomFields, newResourceCustomFields, oldResource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
            }
            catch (BuildUpdateActionException exception) {
                String errorMessage = String.format(CUSTOM_FIELDS_UPDATE_ACTIONS_BUILD_FAILED, resourceTypeIdGetter.apply(oldResource), resourceIdGetter.apply(oldResource), exception.getMessage());
                syncOptions.applyErrorCallback(new SyncException(errorMessage, exception), oldMainResource != null ? oldMainResource : oldResource, newMainResourceDraft != null ? newMainResourceDraft : newResourceDraft, null);
                return Collections.emptyList();
            }
        } else {
            if (oldResourceCustomFields != null) return Collections.singletonList(customActionBuilder.buildRemoveCustomTypeAction(variantId, updateIdGetter.apply(oldResource)));
            if (newResourceCustomFields == null) return Collections.emptyList();
            String newCustomFieldsTypeId = newResourceCustomFields.getType().getId();
            if (StringUtils.isBlank((CharSequence)newCustomFieldsTypeId)) {
                String errorMessage = String.format(CUSTOM_FIELDS_UPDATE_ACTIONS_BUILD_FAILED, resourceTypeIdGetter.apply(oldResource), resourceIdGetter.apply(oldResource), CUSTOM_TYPE_ID_IS_BLANK);
                syncOptions.applyErrorCallback(new SyncException(errorMessage, null), oldMainResource != null ? oldMainResource : oldResource, newMainResourceDraft != null ? newMainResourceDraft : newResourceDraft, null);
                return Collections.emptyList();
            } else {
                Map newCustomFieldsJsonMap = newResourceCustomFields.getFields();
                Optional<UpdateAction<List>> updateAction = GenericUpdateActionUtils.buildTypedSetCustomTypeUpdateAction(newCustomFieldsTypeId, newCustomFieldsJsonMap, oldResource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
                return updateAction.map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
        }
    }

    @Nonnull
    private static <D, T extends Custom, S extends CustomDraft, U extends Resource<U>> List<UpdateAction<U>> buildCustomUpdateActions(@Nonnull T oldResource, @Nonnull S newResourceDraft, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> resourceIdGetter, @Nonnull Function<T, String> resourceTypeIdGetter, @Nonnull Function<T, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(null, null, oldResource, newResourceDraft, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
    }

    @Nonnull
    static <T extends Custom, U extends Resource<U>> List<UpdateAction<U>> buildNonNullCustomFieldsUpdateActions(@Nonnull CustomFields oldCustomFields, @Nonnull CustomFieldsDraft newCustomFields, @Nonnull T resource, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> resourceIdGetter, @Nonnull Function<T, String> resourceTypeIdGetter, @Nonnull Function<T, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) throws BuildUpdateActionException {
        String oldCustomTypeId = oldCustomFields.getType().getId();
        Map oldCustomFieldsJsonMap = oldCustomFields.getFieldsJsonMap();
        String newCustomTypeId = newCustomFields.getType().getId();
        Map newCustomFieldsJsonMap = newCustomFields.getFields();
        if (Objects.equals(oldCustomTypeId, newCustomTypeId)) {
            if (StringUtils.isBlank((CharSequence)oldCustomTypeId)) {
                throw new BuildUpdateActionException(String.format(CUSTOM_TYPE_IDS_NOT_SET, resourceTypeIdGetter.apply(resource)));
            }
            if (newCustomFieldsJsonMap == null) {
                Optional<UpdateAction<List>> updateAction = GenericUpdateActionUtils.buildTypedSetCustomTypeUpdateAction(newCustomTypeId, null, resource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
                return updateAction.map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            return CustomUpdateActionUtils.buildSetCustomFieldsUpdateActions(oldCustomFieldsJsonMap, newCustomFieldsJsonMap, resource, customActionBuilder, variantId, updateIdGetter);
        }
        Optional<UpdateAction<List>> updateAction = GenericUpdateActionUtils.buildTypedSetCustomTypeUpdateAction(newCustomTypeId, newCustomFieldsJsonMap, resource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
        return updateAction.map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    @Nonnull
    static <T extends Custom, U extends Resource<U>> List<UpdateAction<U>> buildSetCustomFieldsUpdateActions(@Nonnull Map<String, JsonNode> oldCustomFields, @Nonnull Map<String, JsonNode> newCustomFields, @Nonnull T resource, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> updateIdGetter) {
        List<UpdateAction<U>> customFieldsUpdateActions = CustomUpdateActionUtils.buildNewOrModifiedCustomFieldsUpdateActions(oldCustomFields, newCustomFields, resource, customActionBuilder, variantId, updateIdGetter);
        List<UpdateAction<U>> removedCustomFieldsActions = CustomUpdateActionUtils.buildRemovedCustomFieldsUpdateActions(oldCustomFields, newCustomFields, resource, customActionBuilder, variantId, updateIdGetter);
        customFieldsUpdateActions.addAll(removedCustomFieldsActions);
        return customFieldsUpdateActions;
    }

    @Nonnull
    private static <T extends Custom, U extends Resource<U>> List<UpdateAction<U>> buildNewOrModifiedCustomFieldsUpdateActions(@Nonnull Map<String, JsonNode> oldCustomFields, @Nonnull Map<String, JsonNode> newCustomFields, @Nonnull T resource, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> updateIdGetter) {
        return newCustomFields.keySet().stream().filter(newCustomFieldName -> {
            JsonNode newCustomFieldValue = (JsonNode)newCustomFields.get(newCustomFieldName);
            JsonNode oldCustomFieldValue = (JsonNode)oldCustomFields.get(newCustomFieldName);
            return !CustomUpdateActionUtils.isNullJsonValue(newCustomFieldValue) && !Objects.equals(newCustomFieldValue, oldCustomFieldValue);
        }).map(newCustomFieldName -> customActionBuilder.buildSetCustomFieldAction(variantId, (String)updateIdGetter.apply(resource), (String)newCustomFieldName, (JsonNode)newCustomFields.get(newCustomFieldName))).collect(Collectors.toList());
    }

    private static boolean isNullJsonValue(@Nullable JsonNode value) {
        return !Objects.nonNull(value) || value.isNull();
    }

    @Nonnull
    private static <T extends Custom, U extends Resource<U>> List<UpdateAction<U>> buildRemovedCustomFieldsUpdateActions(@Nonnull Map<String, JsonNode> oldCustomFields, @Nonnull Map<String, JsonNode> newCustomFields, @Nonnull T resource, @Nonnull GenericCustomActionBuilder<U> customActionBuilder, @Nullable Integer variantId, @Nonnull Function<T, String> updateIdGetter) {
        return oldCustomFields.keySet().stream().filter(oldCustomFieldsName -> CustomUpdateActionUtils.isNullJsonValue((JsonNode)newCustomFields.get(oldCustomFieldsName))).map(oldCustomFieldsName -> customActionBuilder.buildSetCustomFieldAction(variantId, (String)updateIdGetter.apply(resource), (String)oldCustomFieldsName, null)).collect(Collectors.toList());
    }

    private CustomUpdateActionUtils() {
    }
}

