/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class OptionalUtils {
    @Nonnull
    public static <T> List<T> filterEmptyOptionals(@Nonnull Collection<Optional<T>> optionals) {
        return OptionalUtils.filterEmptyOptionals(optionals, ArrayList::new);
    }

    @Nonnull
    @SafeVarargs
    public static <T> List<T> filterEmptyOptionals(Optional<T> ... optionals) {
        return OptionalUtils.filterEmptyOptionals(Arrays.asList(optionals));
    }

    @Nonnull
    private static <T, C extends Collection<T>> C filterEmptyOptionals(@Nonnull Collection<Optional<T>> optionals, @Nonnull Supplier<C> collectionFactory) {
        return (C)((Collection)optionals.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(collectionFactory)));
    }

    private OptionalUtils() {
    }
}

