/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.AssetCustomActionBuilder;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.commands.updateactions.ChangeAssetName;
import io.sphere.sdk.products.commands.updateactions.SetAssetDescription;
import io.sphere.sdk.products.commands.updateactions.SetAssetSources;
import io.sphere.sdk.products.commands.updateactions.SetAssetTags;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ProductVariantAssetUpdateActionUtils {
    @Nonnull
    public static <D> List<UpdateAction<Product>> buildActions(@Nonnull Resource oldResource, @Nonnull D newResource, @Nonnull Integer variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull ProductSyncOptions syncOptions) {
        List<UpdateAction<Product>> updateActions = OptionalUtils.filterEmptyOptionals(ProductVariantAssetUpdateActionUtils.buildChangeAssetNameUpdateAction(variantId, oldAsset, newAsset), ProductVariantAssetUpdateActionUtils.buildSetAssetDescriptionUpdateAction(variantId, oldAsset, newAsset), ProductVariantAssetUpdateActionUtils.buildSetAssetTagsUpdateAction(variantId, oldAsset, newAsset), ProductVariantAssetUpdateActionUtils.buildSetAssetSourcesUpdateAction(variantId, oldAsset, newAsset));
        updateActions.addAll(ProductVariantAssetUpdateActionUtils.buildCustomUpdateActions(oldResource, newResource, variantId, oldAsset, newAsset, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildChangeAssetNameUpdateAction(@Nonnull Integer variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getName(), newAsset.getName(), () -> ChangeAssetName.ofAssetKeyAndVariantId((Integer)variantId, (String)oldAsset.getKey(), (LocalizedString)newAsset.getName(), (Boolean)true));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetAssetDescriptionUpdateAction(@Nonnull Integer variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getDescription(), newAsset.getDescription(), () -> SetAssetDescription.ofVariantIdAndAssetKey((Integer)variantId, (String)oldAsset.getKey(), (LocalizedString)newAsset.getDescription(), (Boolean)true));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetAssetTagsUpdateAction(@Nonnull Integer variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getTags(), newAsset.getTags(), () -> SetAssetTags.ofVariantIdAndAssetKey((Integer)variantId, (String)oldAsset.getKey(), (Set)newAsset.getTags(), (Boolean)true));
    }

    @Nonnull
    public static Optional<UpdateAction<Product>> buildSetAssetSourcesUpdateAction(@Nonnull Integer variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getSources(), newAsset.getSources(), () -> SetAssetSources.ofVariantIdAndAssetKey((Integer)variantId, (String)oldAsset.getKey(), (List)newAsset.getSources(), (Boolean)true));
    }

    @Nonnull
    public static <D> List<UpdateAction<Product>> buildCustomUpdateActions(@Nonnull Resource oldResource, @Nonnull D newResource, @Nonnull Integer variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull ProductSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(oldResource, newResource, oldAsset, newAsset, new AssetCustomActionBuilder(), variantId, Asset::getId, asset -> Asset.resourceTypeId(), Asset::getKey, syncOptions);
    }

    private ProductVariantAssetUpdateActionUtils() {
    }
}

