/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.products.AttributeMetaData;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.attributes.Attribute;
import io.sphere.sdk.products.attributes.AttributeDraft;
import io.sphere.sdk.products.commands.updateactions.SetAttribute;
import io.sphere.sdk.products.commands.updateactions.SetAttributeInAllVariants;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductVariantAttributeUpdateActionUtils {
    public static final String ATTRIBUTE_NOT_IN_ATTRIBUTE_METADATA = "Cannot find the attribute with the name '%s' in the supplied attribute metadata.";

    @Nonnull
    public static Optional<UpdateAction<Product>> buildProductVariantAttributeUpdateAction(int variantId, @Nullable Attribute oldProductVariantAttribute, @Nonnull AttributeDraft newProductVariantAttribute, @Nonnull Map<String, AttributeMetaData> attributesMetaData) throws BuildUpdateActionException {
        String newProductVariantAttributeName = newProductVariantAttribute.getName();
        JsonNode newProductVariantAttributeValue = newProductVariantAttribute.getValue();
        JsonNode oldProductVariantAttributeValue = oldProductVariantAttribute != null ? oldProductVariantAttribute.getValueAsJsonNode() : null;
        AttributeMetaData attributeMetaData = attributesMetaData.get(newProductVariantAttributeName);
        if (attributeMetaData == null) {
            String errorMessage = String.format(ATTRIBUTE_NOT_IN_ATTRIBUTE_METADATA, newProductVariantAttributeName);
            throw new BuildUpdateActionException(errorMessage);
        }
        return attributeMetaData.isSameForAll() ? CommonTypeUpdateActionUtils.buildUpdateAction(oldProductVariantAttributeValue, newProductVariantAttributeValue, () -> SetAttributeInAllVariants.of((AttributeDraft)newProductVariantAttribute, (Boolean)true)) : CommonTypeUpdateActionUtils.buildUpdateAction(oldProductVariantAttributeValue, newProductVariantAttributeValue, () -> SetAttribute.of((Integer)variantId, (AttributeDraft)newProductVariantAttribute, (Boolean)true));
    }

    private ProductVariantAttributeUpdateActionUtils() {
    }
}

