/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.AssetsUpdateActionUtils;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.internals.helpers.PriceCompositeId;
import com.commercetools.sync.internals.utils.UnorderedCollectionSyncUtils;
import com.commercetools.sync.internals.utils.UpdateActionsSortUtils;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.ProductAssetActionFactory;
import com.commercetools.sync.products.utils.ProductVariantAttributeUpdateActionUtils;
import com.commercetools.sync.products.utils.ProductVariantPriceUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Image;
import io.sphere.sdk.products.Price;
import io.sphere.sdk.products.PriceDraft;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.attributes.Attribute;
import io.sphere.sdk.products.attributes.AttributeDraft;
import io.sphere.sdk.products.commands.updateactions.AddExternalImage;
import io.sphere.sdk.products.commands.updateactions.AddPrice;
import io.sphere.sdk.products.commands.updateactions.MoveImageToPosition;
import io.sphere.sdk.products.commands.updateactions.RemoveImage;
import io.sphere.sdk.products.commands.updateactions.RemovePrice;
import io.sphere.sdk.products.commands.updateactions.SetAttribute;
import io.sphere.sdk.products.commands.updateactions.SetAttributeInAllVariants;
import io.sphere.sdk.products.commands.updateactions.SetSku;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductVariantUpdateActionUtils {
    public static final String FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION = "Failed to build a setAttribute/setAttributeInAllVariants update action for the attribute with the name '%s' in the ProductVariantDraft with key '%s' on the product with key '%s'. Reason: %s";
    public static final String NULL_PRODUCT_VARIANT_ATTRIBUTE = "AttributeDraft is null.";
    private static final String NULL_PRODUCT_VARIANT_PRICE = "New price is null.";

    @Nonnull
    public static Optional<SetSku> buildProductVariantSkuUpdateAction(@Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant) {
        String oldProductVariantSku = oldProductVariant.getSku();
        String newProductVariantSku = newProductVariant.getSku();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldProductVariantSku, newProductVariantSku, () -> SetSku.of((Integer)oldProductVariant.getId(), (String)newProductVariantSku, (Boolean)true));
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildProductVariantPricesUpdateActions(@Nullable Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull ProductSyncOptions syncOptions) {
        List oldPrices = oldProductVariant.getPrices();
        List newPrices = newProductVariant.getPrices();
        List<UpdateAction<Product>> updateActions = UnorderedCollectionSyncUtils.buildRemoveUpdateActions(oldPrices, newPrices, PriceCompositeId::of, PriceCompositeId::of, price -> RemovePrice.of((Price)price, (Boolean)true));
        Integer variantId = oldProductVariant.getId();
        Map<PriceCompositeId, Price> oldPricesMap = CollectionUtils.collectionToMap(oldPrices, PriceCompositeId::of);
        CollectionUtils.emptyIfNull(newPrices).forEach(newPrice -> {
            if (newPrice == null) {
                syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build prices update actions for one price on the variant with id '%d' and key '%s'. Reason: %s", variantId, oldProductVariant.getKey(), NULL_PRODUCT_VARIANT_PRICE)), oldProduct, newProduct, null);
            } else {
                PriceCompositeId newPriceCompositeId = PriceCompositeId.of(newPrice);
                Price matchingOldPrice = (Price)oldPricesMap.get(newPriceCompositeId);
                List updateOrAddPrice = Optional.ofNullable(matchingOldPrice).map(oldPrice -> ProductVariantPriceUpdateActionUtils.buildActions(oldProduct, newProduct, variantId, oldPrice, newPrice, syncOptions)).orElseGet(() -> Collections.singletonList(AddPrice.ofVariantId((Integer)variantId, (PriceDraft)newPrice, (Boolean)true)));
                updateActions.addAll(updateOrAddPrice);
            }
        });
        return UpdateActionsSortUtils.sortPriceActions(updateActions);
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildProductVariantImagesUpdateActions(@Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant) {
        List newProductVariantImages;
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>();
        Integer oldProductVariantId = oldProductVariant.getId();
        List oldProductVariantImages = oldProductVariant.getImages();
        if (!Objects.equals(oldProductVariantImages, newProductVariantImages = newProductVariant.getImages())) {
            ArrayList<Image> updatedOldImages = new ArrayList<Image>(oldProductVariantImages);
            List<Image> newImages = CollectionUtils.emptyIfNull(newProductVariantImages);
            CollectionUtils.filterCollection(oldProductVariantImages, oldVariantImage -> !newImages.contains(oldVariantImage)).forEach(oldImage -> {
                updateActions.add((UpdateAction<Product>)RemoveImage.ofVariantId((Integer)oldProductVariantId, (Image)oldImage, (Boolean)true));
                updatedOldImages.remove(oldImage);
            });
            CollectionUtils.filterCollection(newProductVariantImages, newVariantImage -> !oldProductVariantImages.contains(newVariantImage)).forEach(newImage -> {
                updateActions.add((UpdateAction<Product>)AddExternalImage.ofVariantId((Integer)oldProductVariantId, (Image)newImage, (Boolean)true));
                updatedOldImages.add((Image)newImage);
            });
            updateActions.addAll(ProductVariantUpdateActionUtils.buildMoveImageToPositionUpdateActions(oldProductVariantId, updatedOldImages, newImages));
        }
        return updateActions;
    }

    public static List<MoveImageToPosition> buildMoveImageToPositionUpdateActions(int variantId, @Nonnull List<Image> oldImages, @Nonnull List<Image> newImages) {
        int newImageListSize;
        int oldImageListSize = oldImages.size();
        if (oldImageListSize != (newImageListSize = newImages.size())) {
            throw new IllegalArgumentException(String.format("Old and new image lists must have the same size, but they have %d and %d respectively", oldImageListSize, newImageListSize));
        }
        HashMap<Image, Integer> imageIndexMap = new HashMap<Image, Integer>(oldImageListSize);
        int index = 0;
        for (Image newImage : newImages) {
            imageIndexMap.put(newImage, index++);
        }
        ArrayList<MoveImageToPosition> updateActions = new ArrayList<MoveImageToPosition>();
        for (int oldIndex = 0; oldIndex < oldImageListSize; ++oldIndex) {
            Image oldImage = oldImages.get(oldIndex);
            Integer newIndex = (Integer)Optional.ofNullable(imageIndexMap.get(oldImage)).orElseThrow(() -> new IllegalArgumentException(String.format("Old image [%s] not found in the new images list.", oldImage)));
            if (oldIndex == newIndex) continue;
            updateActions.add(MoveImageToPosition.ofImageUrlAndVariantId((String)oldImage.getUrl(), (Integer)variantId, (Integer)newIndex, (Boolean)true));
        }
        return updateActions;
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildProductVariantAssetsUpdateActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull ProductSyncOptions syncOptions) {
        try {
            return AssetsUpdateActionUtils.buildAssetsUpdateActions(oldProduct, newProduct, oldProductVariant.getAssets(), newProductVariant.getAssets(), new ProductAssetActionFactory(oldProductVariant.getId(), syncOptions), syncOptions);
        }
        catch (BuildUpdateActionException exception) {
            SyncException syncException = new SyncException(String.format("Failed to build update actions for the assets of the product variant with the sku '%s'. Reason: %s", oldProductVariant.getSku(), exception), exception);
            syncOptions.applyErrorCallback(syncException, oldProduct, newProduct, null);
            return Collections.emptyList();
        }
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildProductVariantAttributesUpdateActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull Map<String, AttributeMetaData> attributesMetaData, @Nonnull ProductSyncOptions syncOptions) {
        String productKey = oldProduct.getKey();
        Integer oldProductVariantId = oldProductVariant.getId();
        List newProductVariantAttributes = newProductVariant.getAttributes();
        List oldProductVariantAttributes = oldProductVariant.getAttributes();
        List<UpdateAction<Product>> updateActions = UnorderedCollectionSyncUtils.buildRemoveUpdateActions(oldProductVariantAttributes, newProductVariantAttributes, Attribute::getName, AttributeDraft::getName, attribute -> {
            try {
                return ProductVariantUpdateActionUtils.buildUnSetAttribute(oldProductVariantId, attribute.getName(), attributesMetaData);
            }
            catch (BuildUpdateActionException buildUpdateActionException) {
                String errorMessage = String.format(FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION, attribute.getName(), newProductVariant.getKey(), productKey, buildUpdateActionException.getMessage());
                syncOptions.applyErrorCallback(new SyncException(errorMessage, new BuildUpdateActionException(errorMessage, buildUpdateActionException)), oldProduct, newProduct, null);
                return null;
            }
        });
        Map<String, Attribute> oldAttributesMap = CollectionUtils.collectionToMap(oldProductVariantAttributes, Attribute::getName);
        CollectionUtils.emptyIfNull(newProductVariantAttributes).forEach(newAttribute -> {
            if (newAttribute == null) {
                String errorMessage = String.format(FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION, null, newProductVariant.getKey(), productKey, NULL_PRODUCT_VARIANT_ATTRIBUTE);
                syncOptions.applyErrorCallback(new SyncException(errorMessage, new BuildUpdateActionException(errorMessage)), oldProduct, newProduct, updateActions);
            } else {
                String newAttributeName = newAttribute.getName();
                Attribute matchingOldAttribute = (Attribute)oldAttributesMap.get(newAttributeName);
                try {
                    ProductVariantAttributeUpdateActionUtils.buildProductVariantAttributeUpdateAction(oldProductVariantId, matchingOldAttribute, newAttribute, attributesMetaData).ifPresent(updateActions::add);
                }
                catch (BuildUpdateActionException buildUpdateActionException) {
                    String errorMessage = String.format(FAILED_TO_BUILD_ATTRIBUTE_UPDATE_ACTION, newAttributeName, newProductVariant.getKey(), productKey, buildUpdateActionException.getMessage());
                    syncOptions.applyErrorCallback(new SyncException(errorMessage, new BuildUpdateActionException(errorMessage, buildUpdateActionException)));
                }
            }
        });
        return updateActions;
    }

    private static UpdateAction<Product> buildUnSetAttribute(@Nonnull Integer variantId, @Nonnull String attributeName, @Nonnull Map<String, AttributeMetaData> attributesMetaData) throws BuildUpdateActionException {
        AttributeMetaData attributeMetaData = attributesMetaData.get(attributeName);
        if (attributeMetaData == null) {
            String errorMessage = String.format("Cannot find the attribute with the name '%s' in the supplied attribute metadata.", attributeName);
            throw new BuildUpdateActionException(errorMessage);
        }
        return attributeMetaData.isSameForAll() ? SetAttributeInAllVariants.ofUnsetAttribute((String)attributeName, (Boolean)true) : SetAttribute.ofUnsetAttribute((Integer)variantId, (String)attributeName, (Boolean)true);
    }

    private ProductVariantUpdateActionUtils() {
    }
}

