/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.sync.commons.exceptions.InvalidReferenceException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.helpers.ProductTypeSyncStatistics;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ProductTypeBatchValidator
extends BaseBatchValidator<ProductTypeDraft, ProductTypeSyncOptions, ProductTypeSyncStatistics> {
    static final String PRODUCT_TYPE_DRAFT_KEY_NOT_SET = "ProductTypeDraft with name: %s doesn't have a key. Please make sure all productType drafts have keys.";
    static final String PRODUCT_TYPE_DRAFT_IS_NULL = "ProductTypeDraft is null.";
    static final String PRODUCT_TYPE_HAS_INVALID_REFERENCES = "ProductTypeDraft with key: '%s' has invalid productType references on the following AttributeDefinitionDrafts: %s";

    public ProductTypeBatchValidator(@Nonnull ProductTypeSyncOptions syncOptions, @Nonnull ProductTypeSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<ProductTypeDraft>, Set<String>> validateAndCollectReferencedKeys(@Nonnull List<ProductTypeDraft> productTypeDrafts) {
        HashSet productTypeKeys = new HashSet();
        Set validDrafts = productTypeDrafts.stream().filter(productTypeDraft -> this.isValidProductTypeDraft((ProductTypeDraft)productTypeDraft, productTypeKeys)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, productTypeKeys);
    }

    private boolean isValidProductTypeDraft(@Nullable ProductTypeDraft productTypeDraft, @Nonnull Set<String> productTypeKeys) {
        if (productTypeDraft == null) {
            this.handleError(PRODUCT_TYPE_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)productTypeDraft.getKey())) {
            this.handleError(String.format(PRODUCT_TYPE_DRAFT_KEY_NOT_SET, productTypeDraft.getName()));
        } else {
            try {
                Set<String> referencedProductTypeKeys = ProductTypeBatchValidator.getReferencedProductTypeKeys(productTypeDraft);
                productTypeKeys.addAll(referencedProductTypeKeys);
                return true;
            }
            catch (SyncException syncException) {
                this.handleError(syncException);
            }
        }
        return false;
    }

    @Nonnull
    private static Set<String> getReferencedProductTypeKeys(@Nonnull ProductTypeDraft productTypeDraft) throws SyncException {
        List attributeDefinitionDrafts = productTypeDraft.getAttributes();
        if (attributeDefinitionDrafts == null || attributeDefinitionDrafts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> referencedProductTypeKeys = new HashSet<String>();
        ArrayList<String> invalidAttributeDefinitionNames = new ArrayList<String>();
        for (AttributeDefinitionDraft attributeDefinitionDraft : attributeDefinitionDrafts) {
            if (attributeDefinitionDraft == null) continue;
            AttributeType attributeType = attributeDefinitionDraft.getAttributeType();
            try {
                ProductTypeBatchValidator.getProductTypeKey(attributeType).ifPresent(referencedProductTypeKeys::add);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                invalidAttributeDefinitionNames.add(attributeDefinitionDraft.getName());
            }
        }
        if (!invalidAttributeDefinitionNames.isEmpty()) {
            String errorMessage = String.format(PRODUCT_TYPE_HAS_INVALID_REFERENCES, productTypeDraft.getKey(), invalidAttributeDefinitionNames);
            throw new SyncException(errorMessage, new InvalidReferenceException("The value of the 'id' field of the Reference is blank (null/empty). Expecting the key of the referenced resource."));
        }
        return referencedProductTypeKeys;
    }

    @Nonnull
    public static Optional<String> getProductTypeKey(@Nonnull AttributeType attributeType) throws InvalidReferenceException {
        if (attributeType instanceof NestedAttributeType) {
            NestedAttributeType nestedElementType = (NestedAttributeType)attributeType;
            return Optional.of(ProductTypeBatchValidator.getProductTypeKey(nestedElementType));
        }
        if (attributeType instanceof SetAttributeType) {
            SetAttributeType setAttributeType = (SetAttributeType)attributeType;
            return ProductTypeBatchValidator.getProductTypeKey(setAttributeType.getElementType());
        }
        return Optional.empty();
    }

    @Nonnull
    private static String getProductTypeKey(@Nonnull NestedAttributeType nestedAttributeType) throws InvalidReferenceException {
        String key = nestedAttributeType.getTypeReference().getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new InvalidReferenceException("The value of the 'id' field of the Reference is blank (null/empty). Expecting the key of the referenced resource.");
        }
        return key;
    }
}

