/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.ResourceKeyId;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.DraftBasedCreateCommand;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.commands.UpdateCommand;
import io.sphere.sdk.models.ResourceView;
import io.sphere.sdk.queries.MetaModelQueryDsl;
import io.sphere.sdk.queries.QueryDsl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

abstract class BaseService<T, U extends ResourceView<U, U>, S extends BaseSyncOptions, Q extends MetaModelQueryDsl<U, Q, M, E>, M, E> {
    final S syncOptions;
    protected final Cache<String, String> keyToIdCache;
    private static final int MAXIMUM_ALLOWED_UPDATE_ACTIONS = 500;
    static final String CREATE_FAILED = "Failed to create draft with key: '%s'. Reason: %s";

    BaseService(@Nonnull S syncOptions) {
        this.syncOptions = syncOptions;
        this.keyToIdCache = Caffeine.newBuilder().maximumSize(((BaseSyncOptions)syncOptions).getCacheSize()).executor(Runnable::run).build();
    }

    @Nonnull
    CompletionStage<U> updateResource(@Nonnull U resource, @Nonnull BiFunction<U, List<? extends UpdateAction<U>>, UpdateCommand<U>> updateCommandFunction, @Nonnull List<UpdateAction<U>> updateActions) {
        List<List<UpdateAction<U>>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        return this.updateBatches(CompletableFuture.completedFuture(resource), updateCommandFunction, actionBatches);
    }

    @Nonnull
    private CompletionStage<U> updateBatches(@Nonnull CompletionStage<U> result, @Nonnull BiFunction<U, List<? extends UpdateAction<U>>, UpdateCommand<U>> updateCommandFunction, @Nonnull List<List<UpdateAction<U>>> batches) {
        CompletionStage<U> resultStage = result;
        for (List<UpdateAction<U>> batch : batches) {
            resultStage = resultStage.thenCompose(updatedProduct -> ((BaseSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)updateCommandFunction.apply(updatedProduct, batch)));
        }
        return resultStage;
    }

    @Nonnull
    CompletionStage<Optional<U>> createResource(@Nonnull T draft, @Nonnull Function<T, String> keyMapper, @Nonnull Function<T, DraftBasedCreateCommand<U, T>> createCommand) {
        String draftKey = keyMapper.apply(draft);
        if (StringUtils.isBlank((CharSequence)draftKey)) {
            ((BaseSyncOptions)this.syncOptions).applyErrorCallback(new SyncException(String.format(CREATE_FAILED, draftKey, "Draft key is blank!")), null, draft, null);
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return this.executeCreateCommand(draft, keyMapper, createCommand);
    }

    @Nonnull
    CompletionStage<Optional<String>> fetchCachedResourceId(@Nullable String key, @Nonnull Function<U, String> keyMapper, @Nonnull Supplier<Q> querySupplier) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        String id = (String)this.keyToIdCache.getIfPresent((Object)key);
        if (id != null) {
            return CompletableFuture.completedFuture(Optional.of(id));
        }
        return this.fetchAndCache(key, keyMapper, querySupplier);
    }

    private CompletionStage<Optional<String>> fetchAndCache(@Nullable String key, @Nonnull Function<U, String> keyMapper, @Nonnull Supplier<Q> querySupplier) {
        Consumer pageConsumer = page -> page.forEach(resource -> this.keyToIdCache.put(keyMapper.apply(resource), (Object)resource.getId()));
        return CtpQueryUtils.queryAll(((BaseSyncOptions)this.syncOptions).getCtpClient(), (QueryDsl)querySupplier.get(), pageConsumer).thenApply(result -> Optional.ofNullable(this.keyToIdCache.getIfPresent((Object)key)));
    }

    @Nonnull
    CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> keys, @Nonnull Function<U, String> keyMapper, @Nonnull Function<Set<String>, Q> keysQueryMapper) {
        Set<String> keysNotCached = this.getKeysNotCached(keys);
        if (keysNotCached.isEmpty()) {
            return CompletableFuture.completedFuture(this.keyToIdCache.asMap());
        }
        Consumer pageConsumer = page -> page.forEach(resource -> this.keyToIdCache.put(keyMapper.apply(resource), (Object)resource.getId()));
        return CtpQueryUtils.queryAll(((BaseSyncOptions)this.syncOptions).getCtpClient(), (QueryDsl)keysQueryMapper.apply(keysNotCached), pageConsumer).thenApply(result -> this.keyToIdCache.asMap());
    }

    @Nonnull
    private Set<String> getKeysNotCached(@Nonnull Set<String> keys) {
        return keys.stream().filter(StringUtils::isNotBlank).filter(key -> !this.keyToIdCache.asMap().containsKey(key)).collect(Collectors.toSet());
    }

    @Nonnull
    CompletionStage<Map<String, String>> cacheKeysToIdsUsingGraphQl(@Nonnull Set<String> keys, @Nonnull Function<ResourceKeyId, Map<String, String>> keyToIdMapper, @Nonnull Function<Set<String>, ResourceKeyIdGraphQlRequest> keysRequestMapper) {
        Set<String> keysNotCached = this.getKeysNotCached(keys);
        if (keysNotCached.isEmpty()) {
            return CompletableFuture.completedFuture(this.keyToIdCache.asMap());
        }
        Consumer resultConsumer = results -> results.forEach(resource -> this.keyToIdCache.putAll((Map)keyToIdMapper.apply((ResourceKeyId)resource)));
        return CtpQueryUtils.queryAll(((BaseSyncOptions)this.syncOptions).getCtpClient(), keysRequestMapper.apply(keysNotCached), resultConsumer).thenApply(result -> this.keyToIdCache.asMap());
    }

    @Nonnull
    CompletionStage<Set<U>> fetchMatchingResources(@Nonnull Set<String> keys, @Nonnull Function<U, String> keyMapper, @Nonnull Supplier<Q> querySupplier) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        return CtpQueryUtils.queryAll(((BaseSyncOptions)this.syncOptions).getCtpClient(), (QueryDsl)querySupplier.get(), Function.identity()).thenApply(fetchedResources -> fetchedResources.stream().flatMap(Collection::stream).peek(resource -> this.keyToIdCache.put(keyMapper.apply(resource), (Object)resource.getId())).collect(Collectors.toSet()));
    }

    @Nonnull
    CompletionStage<Optional<U>> fetchResource(@Nullable String key, @Nonnull Supplier<Q> querySupplier) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return ((BaseSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)querySupplier.get()).thenApply(pagedQueryResult -> pagedQueryResult.head().map(resource -> {
            this.keyToIdCache.put((Object)key, (Object)resource.getId());
            return resource;
        }));
    }

    @Nonnull
    CompletionStage<Optional<U>> executeCreateCommand(@Nonnull T draft, @Nonnull Function<T, String> keyMapper, @Nonnull Function<T, DraftBasedCreateCommand<U, T>> createCommand) {
        String draftKey = keyMapper.apply(draft);
        return ((BaseSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)createCommand.apply(draft)).handle((resource, exception) -> {
            if (exception == null) {
                this.keyToIdCache.put((Object)draftKey, (Object)resource.getId());
                return Optional.of(resource);
            }
            ((BaseSyncOptions)this.syncOptions).applyErrorCallback(new SyncException(String.format(CREATE_FAILED, draftKey, exception.getMessage()), (Throwable)exception), null, (Object)draft, null);
            return Optional.empty();
        });
    }
}

