/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.customergroups.CustomerGroup;
import io.sphere.sdk.customergroups.CustomerGroupDraft;
import io.sphere.sdk.customergroups.expansion.CustomerGroupExpansionModel;
import io.sphere.sdk.customergroups.queries.CustomerGroupQuery;
import io.sphere.sdk.customergroups.queries.CustomerGroupQueryBuilder;
import io.sphere.sdk.customergroups.queries.CustomerGroupQueryModel;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CustomerGroupServiceImpl
extends BaseServiceWithKey<CustomerGroupDraft, CustomerGroup, BaseSyncOptions, CustomerGroupQuery, CustomerGroupQueryModel, CustomerGroupExpansionModel<CustomerGroup>>
implements CustomerGroupService {
    public CustomerGroupServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> customerGroupKeys) {
        return this.cacheKeysToIds(customerGroupKeys, keysNotCached -> new ResourceKeyIdGraphQlRequest((Set<String>)keysNotCached, GraphQlQueryResources.CUSTOMER_GROUPS));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomerGroupId(@Nullable String key) {
        return this.fetchCachedResourceId(key, () -> CustomerGroupQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build());
    }
}

