/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.services.ShoppingListService;
import com.commercetools.sync.services.impl.BaseService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.commands.ShoppingListCreateCommand;
import io.sphere.sdk.shoppinglists.commands.ShoppingListUpdateCommand;
import io.sphere.sdk.shoppinglists.expansion.ShoppingListExpansionModel;
import io.sphere.sdk.shoppinglists.queries.ShoppingListQuery;
import io.sphere.sdk.shoppinglists.queries.ShoppingListQueryModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ShoppingListServiceImpl
extends BaseService<ShoppingListDraft, ShoppingList, ShoppingListSyncOptions, ShoppingListQuery, ShoppingListQueryModel, ShoppingListExpansionModel<ShoppingList>>
implements ShoppingListService {
    public ShoppingListServiceImpl(@Nonnull ShoppingListSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> shoppingListKeys) {
        return this.cacheKeysToIdsUsingGraphQl(shoppingListKeys, resource -> Collections.singletonMap(resource.getKey(), resource.getId()), keysNotCached -> new ResourceKeyIdGraphQlRequest((Set<String>)keysNotCached, GraphQlQueryResources.SHOPPING_LISTS));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<ShoppingList>> fetchMatchingShoppingListsByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, ShoppingList::getKey, () -> (ShoppingListQuery)ShoppingListQuery.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keys)).plusExpansionPaths(ExpansionPath.of((String)"lineItems[*].variant")));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ShoppingList>> fetchShoppingList(@Nullable String key) {
        return this.fetchResource(key, () -> (ShoppingListQuery)ShoppingListQuery.of().plusPredicates(queryModel -> queryModel.key().is(key)).plusExpansionPaths(ExpansionPath.of((String)"lineItems[*].variant")));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ShoppingList>> createShoppingList(@Nonnull ShoppingListDraft shoppingListDraft) {
        return this.createResource(shoppingListDraft, ShoppingListDraft::getKey, ShoppingListCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<ShoppingList> updateShoppingList(@Nonnull ShoppingList shoppingList, @Nonnull List<UpdateAction<ShoppingList>> updateActions) {
        return this.updateResource(shoppingList, ShoppingListUpdateCommand::of, updateActions);
    }
}

