/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.commands.updateactions.AddTextLineItemWithAddedAt;
import com.commercetools.sync.shoppinglists.utils.TextLineItemCustomActionBuilder;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.TextLineItem;
import io.sphere.sdk.shoppinglists.TextLineItemDraft;
import io.sphere.sdk.shoppinglists.commands.updateactions.ChangeTextLineItemName;
import io.sphere.sdk.shoppinglists.commands.updateactions.ChangeTextLineItemQuantity;
import io.sphere.sdk.shoppinglists.commands.updateactions.RemoveTextLineItem;
import io.sphere.sdk.shoppinglists.commands.updateactions.SetTextLineItemDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;

public final class TextLineItemUpdateActionUtils {
    @Nonnull
    public static List<UpdateAction<ShoppingList>> buildTextLineItemsUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull ShoppingListSyncOptions syncOptions) {
        boolean hasNewTextLineItems;
        boolean hasOldTextLineItems = oldShoppingList.getTextLineItems() != null && !oldShoppingList.getTextLineItems().isEmpty();
        boolean bl = hasNewTextLineItems = newShoppingList.getTextLineItems() != null && !newShoppingList.getTextLineItems().isEmpty() && newShoppingList.getTextLineItems().stream().anyMatch(Objects::nonNull);
        if (hasOldTextLineItems && !hasNewTextLineItems) {
            return oldShoppingList.getTextLineItems().stream().map(RemoveTextLineItem::of).collect(Collectors.toList());
        }
        if (!hasOldTextLineItems) {
            if (!hasNewTextLineItems) {
                return Collections.emptyList();
            }
            return newShoppingList.getTextLineItems().stream().filter(Objects::nonNull).filter(TextLineItemUpdateActionUtils::hasQuantity).map(AddTextLineItemWithAddedAt::of).collect(Collectors.toList());
        }
        List oldTextLineItems = oldShoppingList.getTextLineItems();
        List<TextLineItemDraft> newTextLineItems = newShoppingList.getTextLineItems().stream().filter(Objects::nonNull).collect(Collectors.toList());
        return TextLineItemUpdateActionUtils.buildUpdateActions(oldShoppingList, newShoppingList, oldTextLineItems, newTextLineItems, syncOptions);
    }

    private static boolean hasQuantity(@Nonnull TextLineItemDraft textLineItemDraft) {
        return textLineItemDraft.getQuantity() != null && textLineItemDraft.getQuantity() > 0L;
    }

    @Nonnull
    private static List<UpdateAction<ShoppingList>> buildUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull List<TextLineItem> oldTextLineItems, @Nonnull List<TextLineItemDraft> newTextLineItems, @Nonnull ShoppingListSyncOptions syncOptions) {
        int i;
        ArrayList updateActions = new ArrayList();
        int minSize = Math.min(oldTextLineItems.size(), newTextLineItems.size());
        for (i = 0; i < minSize; ++i) {
            TextLineItem oldTextLineItem = oldTextLineItems.get(i);
            TextLineItemDraft newTextLineItem = newTextLineItems.get(i);
            if (newTextLineItem.getName() == null || newTextLineItem.getName().getLocales().isEmpty()) {
                syncOptions.applyErrorCallback(new SyncException(String.format("TextLineItemDraft at position '%d' of the ShoppingListDraft with key '%s' has no name set. Please make sure all text line items have names.", i, newShoppingList.getKey())), oldShoppingList, newShoppingList, updateActions);
                return Collections.emptyList();
            }
            updateActions.addAll(TextLineItemUpdateActionUtils.buildTextLineItemUpdateActions(oldShoppingList, newShoppingList, oldTextLineItem, newTextLineItem, syncOptions));
        }
        for (i = minSize; i < oldTextLineItems.size(); ++i) {
            updateActions.add(RemoveTextLineItem.of((String)oldTextLineItems.get(i).getId()));
        }
        for (i = minSize; i < newTextLineItems.size(); ++i) {
            if (!TextLineItemUpdateActionUtils.hasQuantity(newTextLineItems.get(i))) continue;
            updateActions.add(AddTextLineItemWithAddedAt.of(newTextLineItems.get(i)));
        }
        return updateActions;
    }

    @Nonnull
    public static List<UpdateAction<ShoppingList>> buildTextLineItemUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem, @Nonnull ShoppingListSyncOptions syncOptions) {
        List<UpdateAction<ShoppingList>> updateActions = OptionalUtils.filterEmptyOptionals(TextLineItemUpdateActionUtils.buildChangeTextLineItemNameUpdateAction(oldTextLineItem, newTextLineItem), TextLineItemUpdateActionUtils.buildSetTextLineItemDescriptionUpdateAction(oldTextLineItem, newTextLineItem), TextLineItemUpdateActionUtils.buildChangeTextLineItemQuantityUpdateAction(oldTextLineItem, newTextLineItem));
        updateActions.addAll(TextLineItemUpdateActionUtils.buildTextLineItemCustomUpdateActions(oldShoppingList, newShoppingList, oldTextLineItem, newTextLineItem, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildChangeTextLineItemNameUpdateAction(@Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTextLineItem.getName(), newTextLineItem.getName(), () -> ChangeTextLineItemName.of((String)oldTextLineItem.getId(), (LocalizedString)newTextLineItem.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildSetTextLineItemDescriptionUpdateAction(@Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTextLineItem.getDescription(), newTextLineItem.getDescription(), () -> SetTextLineItemDescription.of((TextLineItem)oldTextLineItem).withDescription(newTextLineItem.getDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildChangeTextLineItemQuantityUpdateAction(@Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem) {
        Long newTextLineItemQuantity = newTextLineItem.getQuantity() == null ? NumberUtils.LONG_ONE : newTextLineItem.getQuantity();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTextLineItem.getQuantity(), newTextLineItemQuantity, () -> ChangeTextLineItemQuantity.of((String)oldTextLineItem.getId(), (Long)newTextLineItemQuantity));
    }

    @Nonnull
    public static List<UpdateAction<ShoppingList>> buildTextLineItemCustomUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem, @Nonnull ShoppingListSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions((Resource)oldShoppingList, newShoppingList, () -> ((TextLineItem)oldTextLineItem).getCustom(), () -> ((TextLineItemDraft)newTextLineItem).getCustom(), new TextLineItemCustomActionBuilder(), null, t -> oldTextLineItem.getId(), textLineItem -> TextLineItem.resourceTypeId(), t -> oldTextLineItem.getId(), syncOptions);
    }

    private TextLineItemUpdateActionUtils() {
    }
}

