/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.service.impl;

import com.commercetools.sync.cartdiscounts.service.CartDiscountTransformService;
import com.commercetools.sync.cartdiscounts.utils.CartDiscountReferenceResolutionUtils;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import io.sphere.sdk.cartdiscounts.CartDiscount;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.types.CustomFields;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CartDiscountTransformServiceImpl
extends BaseTransformServiceImpl
implements CartDiscountTransformService {
    public CartDiscountTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<CartDiscountDraft>> toCartDiscountDrafts(@Nonnull List<CartDiscount> cartDiscounts) {
        return this.transformCustomTypeReference(cartDiscounts).thenApply(ignore -> CartDiscountReferenceResolutionUtils.mapToCartDiscountDrafts(cartDiscounts, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<CartDiscount> cartDiscounts) {
        Set<String> setOfTypeIds = cartDiscounts.stream().map(CartDiscount::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.TYPES);
    }
}

