/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.helpers.GraphQlBaseRequestImpl;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.models.ResourceKeyIdGraphQlResult;
import io.sphere.sdk.http.HttpResponse;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceKeyIdGraphQlRequest
extends GraphQlBaseRequestImpl<ResourceKeyIdGraphQlResult> {
    protected final Set<String> keysToSearch;
    protected final GraphQlQueryResources resource;

    public ResourceKeyIdGraphQlRequest(@Nonnull Set<String> keysToSearch, @Nonnull GraphQlQueryResources resource) {
        this.keysToSearch = Objects.requireNonNull(keysToSearch);
        this.resource = resource;
    }

    @Nullable
    public ResourceKeyIdGraphQlResult deserialize(HttpResponse httpResponse) {
        return this.deserializeWithResourceName(httpResponse, this.resource.getName(), ResourceKeyIdGraphQlResult.class);
    }

    @Override
    @Nonnull
    protected String buildQueryString() {
        return String.format("%s(limit: %d, where: \\\"%s\\\", sort: [\\\"id asc\\\"]) { results { id key } }", this.resource.getName(), this.limit, this.createWhereQuery(this.keysToSearch));
    }

    @Nonnull
    private String createWhereQuery(@Nonnull Set<String> keys) {
        String backslashQuote = "\\\\\\\"";
        String commaSeparatedKeys = keys.stream().filter(key -> !StringUtils.isBlank((CharSequence)key)).map(key -> StringEscapeUtils.escapeJava((String)key)).collect(Collectors.joining(String.format("%s, %s", "\\\\\\\"", "\\\\\\\""), "\\\\\\\"", "\\\\\\\""));
        String whereQuery = ResourceKeyIdGraphQlRequest.createWhereQuery(commaSeparatedKeys);
        return StringUtils.isBlank((CharSequence)this.queryPredicate) ? whereQuery : String.format("%s AND %s", whereQuery, this.queryPredicate);
    }

    @Nonnull
    private static String createWhereQuery(@Nonnull String commaSeparatedKeys) {
        return String.format("key in (%s)", commaSeparatedKeys);
    }
}

