/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.models.GraphQlBaseRequest;
import com.commercetools.sync.commons.models.GraphQlBaseResource;
import com.commercetools.sync.commons.models.GraphQlBaseResult;
import io.sphere.sdk.client.SphereClient;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

final class GraphQlQueryAll<T extends GraphQlBaseResult<U>, U extends GraphQlBaseResource> {
    private final SphereClient client;
    private final GraphQlBaseRequest<T> graphqlRequest;
    private final long pageSize;
    private Consumer<Set<U>> pageConsumer;

    private GraphQlQueryAll(@Nonnull SphereClient client, @Nonnull GraphQlBaseRequest<T> graphqlRequest, long pageSize) {
        this.client = client;
        this.graphqlRequest = graphqlRequest.withLimit(pageSize);
        this.pageSize = pageSize;
    }

    @Nonnull
    static <T extends GraphQlBaseResult<U>, U extends GraphQlBaseResource> GraphQlQueryAll<T, U> of(@Nonnull SphereClient client, @Nonnull GraphQlBaseRequest<T> graphqlRequest, int pageSize) {
        return new GraphQlQueryAll<T, U>(client, graphqlRequest, pageSize);
    }

    @Nonnull
    CompletionStage<Void> run(@Nonnull Consumer<Set<U>> pageConsumer) {
        this.pageConsumer = pageConsumer;
        CompletionStage firstPage = this.client.execute(this.graphqlRequest);
        return this.queryNextPages(firstPage);
    }

    @Nonnull
    private CompletionStage<Void> queryNextPages(@Nonnull CompletionStage<T> currentPageStage) {
        return currentPageStage.thenCompose(currentPage -> currentPage != null ? this.queryNextPages(this.processPageAndGetNext(currentPage)) : CompletableFuture.completedFuture(null));
    }

    @Nonnull
    private CompletionStage<T> processPageAndGetNext(@Nonnull T page) {
        Set currentPageElements = page.getResults();
        if (!currentPageElements.isEmpty()) {
            this.consumePageElements(currentPageElements);
            return this.getNextPageStage(currentPageElements);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void consumePageElements(@Nonnull Set<U> pageElements) {
        this.pageConsumer.accept(pageElements);
    }

    @Nonnull
    private CompletionStage<T> getNextPageStage(@Nonnull Set<U> pageElements) {
        if ((long)pageElements.size() == this.pageSize) {
            String lastElementId = "";
            for (GraphQlBaseResource pageElement : pageElements) {
                lastElementId = pageElement.getId();
            }
            String queryPredicate = StringUtils.isBlank((CharSequence)lastElementId) ? null : String.format("id > \\\\\\\"%s\\\\\\\"", lastElementId);
            return this.client.execute(this.graphqlRequest.withPredicate(queryPredicate));
        }
        return CompletableFuture.completedFuture(null);
    }
}

