/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.customers.CustomerDraft;
import io.sphere.sdk.customers.CustomerDraftBuilder;
import io.sphere.sdk.models.Address;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.stores.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.util.TextUtils;

public final class CustomerReferenceResolutionUtils {
    @Nonnull
    public static List<CustomerDraft> mapToCustomerDrafts(@Nonnull List<Customer> customers, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return customers.stream().map(customer -> CustomerReferenceResolutionUtils.mapToCustomerDraft(customer, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static CustomerDraft mapToCustomerDraft(@Nonnull Customer customer, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return ((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)((CustomerDraftBuilder)CustomerDraftBuilder.of((String)customer.getEmail(), (String)customer.getPassword()).customerNumber(customer.getCustomerNumber())).key(customer.getKey())).firstName(customer.getFirstName())).lastName(customer.getLastName())).middleName(customer.getMiddleName())).title(customer.getTitle())).externalId(customer.getExternalId())).companyName(customer.getCompanyName())).customerGroup(SyncUtils.getResourceIdentifierWithKey(customer.getCustomerGroup(), referenceIdToKeyCache))).dateOfBirth(customer.getDateOfBirth())).isEmailVerified(customer.isEmailVerified())).vatId(customer.getVatId())).addresses(customer.getAddresses())).defaultBillingAddress(CustomerReferenceResolutionUtils.getAddressIndex(customer.getAddresses(), customer.getDefaultBillingAddressId()))).billingAddresses(CustomerReferenceResolutionUtils.getAddressIndexList(customer.getAddresses(), customer.getBillingAddressIds()))).defaultShippingAddress(CustomerReferenceResolutionUtils.getAddressIndex(customer.getAddresses(), customer.getDefaultShippingAddressId()))).shippingAddresses(CustomerReferenceResolutionUtils.getAddressIndexList(customer.getAddresses(), customer.getShippingAddressIds()))).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(customer, referenceIdToKeyCache))).locale(customer.getLocale())).salutation(customer.getSalutation())).stores(CustomerReferenceResolutionUtils.mapToStores(customer))).build();
    }

    @Nullable
    private static Integer getAddressIndex(@Nullable List<Address> allAddresses, @Nullable String addressId) {
        if (allAddresses == null) {
            return null;
        }
        if (TextUtils.isBlank((CharSequence)addressId)) {
            return null;
        }
        for (int i = 0; i < allAddresses.size(); ++i) {
            String id = allAddresses.get(i).getId();
            if (id == null || !id.equals(addressId)) continue;
            return i;
        }
        return null;
    }

    @Nullable
    private static List<Integer> getAddressIndexList(@Nullable List<Address> allAddresses, @Nullable List<String> addressIds) {
        if (allAddresses == null || addressIds == null) {
            return null;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String addressId : addressIds) {
            indexes.add(CustomerReferenceResolutionUtils.getAddressIndex(allAddresses, addressId));
        }
        return indexes;
    }

    @Nullable
    private static List<ResourceIdentifier<Store>> mapToStores(@Nonnull Customer customer) {
        List storeReferences = customer.getStores();
        if (storeReferences != null) {
            return storeReferences.stream().map(storeKeyReference -> ResourceIdentifier.ofKey((String)storeKeyReference.getKey())).collect(Collectors.toList());
        }
        return null;
    }

    private CustomerReferenceResolutionUtils() {
    }
}

