/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.service.impl;

import com.commercetools.sync.commons.exceptions.ReferenceTransformException;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.models.ResourceIdsGraphQlRequest;
import com.commercetools.sync.commons.models.ResourceKeyId;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.products.service.ProductTransformService;
import com.commercetools.sync.products.utils.ProductReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.customobjects.CustomObject;
import io.sphere.sdk.customobjects.queries.CustomObjectQuery;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.AttributeContainer;
import io.sphere.sdk.products.Price;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductLike;
import io.sphere.sdk.products.ProductProjection;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.attributes.Attribute;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.states.State;
import io.sphere.sdk.types.CustomFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ProductTransformServiceImpl
extends BaseTransformServiceImpl
implements ProductTransformService {
    private static final String FAILED_TO_REPLACE_REFERENCES_ON_ATTRIBUTES = "Failed to replace referenced resource ids with keys on the attributes of the products in the current fetched page from the source project. This page will not be synced to the target project.";

    public ProductTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<ProductDraft>> toProductDrafts(@Nonnull List<ProductProjection> products) {
        return this.replaceAttributeReferenceIdsWithKeys(products).handle((productsResolved, throwable) -> {
            if (throwable != null) {
                throw new ReferenceTransformException(FAILED_TO_REPLACE_REFERENCES_ON_ATTRIBUTES, (Throwable)throwable);
            }
            return productsResolved;
        }).thenCompose(productsWithAttributesResolved -> this.transformReferencesAndMapToProductDrafts((List<ProductProjection>)productsWithAttributesResolved)).toCompletableFuture();
    }

    @Nonnull
    private CompletionStage<List<ProductDraft>> transformReferencesAndMapToProductDrafts(@Nonnull List<ProductProjection> products) {
        ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
        transformReferencesToRunParallel.add(this.transformProductTypeReference(products));
        transformReferencesToRunParallel.add(this.transformTaxCategoryReference(products));
        transformReferencesToRunParallel.add(this.transformStateReference(products));
        transformReferencesToRunParallel.add(this.transformCategoryReference(products));
        transformReferencesToRunParallel.add(this.transformPricesChannelReference(products));
        transformReferencesToRunParallel.add(this.transformCustomTypeReference(products));
        transformReferencesToRunParallel.add(this.transformPricesCustomerGroupReference(products));
        return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> ProductReferenceResolutionUtils.mapToProductDrafts(products, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformProductTypeReference(@Nonnull List<ProductProjection> products) {
        Set<String> productTypeIds = products.stream().map(ProductLike::getProductType).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(productTypeIds, GraphQlQueryResources.PRODUCT_TYPES);
    }

    @Nonnull
    private CompletableFuture<Void> transformTaxCategoryReference(@Nonnull List<ProductProjection> products) {
        Set<String> taxCategoryIds = products.stream().map(ProductLike::getTaxCategory).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(taxCategoryIds, GraphQlQueryResources.TAX_CATEGORIES);
    }

    @Nonnull
    private CompletableFuture<Void> transformStateReference(@Nonnull List<ProductProjection> products) {
        Set<String> stateIds = products.stream().map(ProductProjection::getState).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(stateIds, GraphQlQueryResources.STATES);
    }

    @Nonnull
    private CompletableFuture<Void> transformCategoryReference(@Nonnull List<ProductProjection> products) {
        Set<String> categoryIds = products.stream().map(product -> product.getCategories()).filter(Objects::nonNull).map(categories -> categories.stream().map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(categoryIds, GraphQlQueryResources.CATEGORIES);
    }

    @Nonnull
    private CompletableFuture<Void> transformPricesChannelReference(@Nonnull List<ProductProjection> products) {
        Set<String> channelIds = products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getPrices().stream().map(Price::getChannel).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(channelIds, GraphQlQueryResources.CHANNELS);
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<ProductProjection> products) {
        HashSet<String> setOfTypeIds = new HashSet<String>();
        setOfTypeIds.addAll(this.collectPriceCustomTypeIds(products));
        setOfTypeIds.addAll(this.collectAssetCustomTypeIds(products));
        return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.TYPES);
    }

    private Set<String> collectPriceCustomTypeIds(@Nonnull List<ProductProjection> products) {
        return products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getPrices().stream().map(Price::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> collectAssetCustomTypeIds(@Nonnull List<ProductProjection> products) {
        return products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getAssets().stream().map(Asset::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    private CompletableFuture<Void> transformPricesCustomerGroupReference(@Nonnull List<ProductProjection> products) {
        Set<String> customerGroupIds = products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getPrices().stream().map(Price::getCustomerGroup).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(customerGroupIds, GraphQlQueryResources.CUSTOMER_GROUPS);
    }

    @Nonnull
    public CompletionStage<List<ProductProjection>> replaceAttributeReferenceIdsWithKeys(@Nonnull List<ProductProjection> products) {
        List<JsonNode> allAttributeReferences = this.getAllReferences(products);
        List<JsonNode> allProductReferences = this.getReferencesByTypeId(allAttributeReferences, Product.referenceTypeId());
        List<JsonNode> allCategoryReferences = this.getReferencesByTypeId(allAttributeReferences, Category.referenceTypeId());
        List<JsonNode> allProductTypeReferences = this.getReferencesByTypeId(allAttributeReferences, ProductType.referenceTypeId());
        List<JsonNode> allCustomObjectReferences = this.getReferencesByTypeId(allAttributeReferences, CustomObject.referenceTypeId());
        List<JsonNode> allStateReferences = this.getReferencesByTypeId(allAttributeReferences, State.referenceTypeId());
        List<JsonNode> allCustomerReferences = this.getReferencesByTypeId(allAttributeReferences, Customer.referenceTypeId());
        return this.getIdToKeys(ProductTransformServiceImpl.getIds(allProductReferences), ProductTransformServiceImpl.getIds(allCategoryReferences), ProductTransformServiceImpl.getIds(allProductTypeReferences), ProductTransformServiceImpl.getIds(allCustomObjectReferences), ProductTransformServiceImpl.getIds(allStateReferences), ProductTransformServiceImpl.getIds(allCustomerReferences)).thenApply(referenceIdToKeyCache -> {
            ProductTransformServiceImpl.replaceReferences(this.getAllReferences(products), referenceIdToKeyCache);
            return products;
        });
    }

    @Nonnull
    private List<JsonNode> getAllReferences(@Nonnull List<ProductProjection> products) {
        return products.stream().map(this::getAllReferences).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private List<JsonNode> getAllReferences(@Nonnull ProductProjection product) {
        List allVariants = product.getAllVariants();
        return ProductTransformServiceImpl.getAttributeReferences(allVariants);
    }

    @Nonnull
    private static List<JsonNode> getAttributeReferences(@Nonnull List<ProductVariant> variants) {
        return variants.stream().map(AttributeContainer::getAttributes).flatMap(Collection::stream).map(Attribute::getValueAsJsonNode).map(ProductTransformServiceImpl::getReferences).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static List<JsonNode> getReferences(@Nonnull JsonNode attributeValue) {
        return attributeValue.findParents("typeId");
    }

    @Nonnull
    private List<JsonNode> getReferencesByTypeId(@Nonnull List<JsonNode> references, @Nonnull String typeId) {
        return references.stream().filter(reference -> typeId.equals(reference.get("typeId").asText())).collect(Collectors.toList());
    }

    @Nonnull
    private static Set<String> getIds(@Nonnull List<JsonNode> references) {
        return references.stream().map(ProductTransformServiceImpl::getId).collect(Collectors.toSet());
    }

    @Nonnull
    private static String getId(@Nonnull JsonNode ref) {
        return ref.get("id").asText();
    }

    private static void replaceReferences(@Nonnull List<JsonNode> references, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        references.forEach(reference -> {
            String id = reference.get("id").asText();
            String key = referenceIdToKeyCache.get(id);
            ((ObjectNode)reference).put("id", key);
        });
    }

    @Nonnull
    CompletableFuture<ReferenceIdToKeyCache> getIdToKeys(@Nonnull Set<String> productIds, @Nonnull Set<String> categoryIds, @Nonnull Set<String> productTypeIds, @Nonnull Set<String> customObjectIds, @Nonnull Set<String> stateIds, @Nonnull Set<String> customerIds) {
        Set<String> nonCachedProductIds = this.getNonCachedReferenceIds(productIds);
        Set<String> nonCachedCategoryIds = this.getNonCachedReferenceIds(categoryIds);
        Set<String> nonCachedProductTypeIds = this.getNonCachedReferenceIds(productTypeIds);
        Set<String> nonCachedCustomObjectIds = this.getNonCachedReferenceIds(customObjectIds);
        Set<String> nonCachedStateIds = this.getNonCachedReferenceIds(stateIds);
        Set<String> nonCachedCustomerIds = this.getNonCachedReferenceIds(customerIds);
        if (nonCachedProductIds.isEmpty() && nonCachedCategoryIds.isEmpty() && nonCachedProductTypeIds.isEmpty() && nonCachedStateIds.isEmpty() && nonCachedCustomerIds.isEmpty()) {
            return this.fetchCustomObjectKeys(nonCachedCustomObjectIds);
        }
        List<List<String>> productIdsChunk = ChunkUtils.chunk(nonCachedProductIds, 300);
        List<List<String>> categoryIdsChunk = ChunkUtils.chunk(nonCachedCategoryIds, 300);
        List<List<String>> productTypeIdsChunk = ChunkUtils.chunk(nonCachedProductTypeIds, 300);
        List<List<String>> stateIdsChunk = ChunkUtils.chunk(nonCachedStateIds, 300);
        List<List<String>> customerIdsChunk = ChunkUtils.chunk(nonCachedCustomerIds, 300);
        ArrayList<ResourceIdsGraphQlRequest> collectedRequests = new ArrayList<ResourceIdsGraphQlRequest>();
        collectedRequests.addAll(this.createResourceIdsGraphQlRequests(productIdsChunk, GraphQlQueryResources.PRODUCTS));
        collectedRequests.addAll(this.createResourceIdsGraphQlRequests(categoryIdsChunk, GraphQlQueryResources.CATEGORIES));
        collectedRequests.addAll(this.createResourceIdsGraphQlRequests(productTypeIdsChunk, GraphQlQueryResources.PRODUCT_TYPES));
        collectedRequests.addAll(this.createResourceIdsGraphQlRequests(stateIdsChunk, GraphQlQueryResources.STATES));
        collectedRequests.addAll(this.createResourceIdsGraphQlRequests(customerIdsChunk, GraphQlQueryResources.CUSTOMERS));
        return ((CompletableFuture)((CompletableFuture)ChunkUtils.executeChunks(this.getCtpClient(), collectedRequests).thenApply(ChunkUtils::flattenGraphQLBaseResults)).thenApply(results -> {
            this.cacheResourceReferenceKeys((Set<ResourceKeyId>)results);
            return this.referenceIdToKeyCache;
        })).thenCompose(ignored -> this.fetchCustomObjectKeys(nonCachedCustomObjectIds));
    }

    @Nonnull
    private CompletableFuture<ReferenceIdToKeyCache> fetchCustomObjectKeys(@Nonnull Set<String> nonCachedCustomObjectIds) {
        if (nonCachedCustomObjectIds.isEmpty()) {
            return CompletableFuture.completedFuture(this.referenceIdToKeyCache);
        }
        List<List<String>> chunkedIds = ChunkUtils.chunk(nonCachedCustomObjectIds, 300);
        List chunkedRequests = chunkedIds.stream().map(ids -> (CustomObjectQuery)((CustomObjectQuery)((CustomObjectQuery)CustomObjectQuery.ofJsonNode().plusPredicates(p -> p.id().isIn((Iterable)ids))).withLimit(300L)).withFetchTotal(false)).collect(Collectors.toList());
        return ((CompletableFuture)ChunkUtils.executeChunks(this.getCtpClient(), chunkedRequests).thenApply(ChunkUtils::flattenPagedQueryResults)).thenApply(customObjects -> {
            customObjects.forEach(customObject -> this.referenceIdToKeyCache.add(customObject.getId(), CustomObjectCompositeIdentifier.of(customObject).toString()));
            return this.referenceIdToKeyCache;
        });
    }
}

