/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.services.ProductTypeService;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraftBuilder;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class AttributeDefinitionReferenceResolver
extends BaseReferenceResolver<AttributeDefinitionDraft, ProductTypeSyncOptions> {
    private final ProductTypeService productTypeService;

    public AttributeDefinitionReferenceResolver(@Nonnull ProductTypeSyncOptions options, @Nonnull ProductTypeService productTypeService) {
        super(options);
        this.productTypeService = productTypeService;
    }

    @Override
    @Nonnull
    public CompletionStage<AttributeDefinitionDraft> resolveReferences(@Nonnull AttributeDefinitionDraft attributeDefinitionDraft) {
        AttributeDefinitionDraftBuilder draftBuilder = AttributeDefinitionDraftBuilder.of((AttributeDefinitionDraft)attributeDefinitionDraft);
        return this.resolveNestedAttributeTypeReferences(draftBuilder).handle(ImmutablePair::new).thenCompose(result -> {
            Throwable exception = (Throwable)result.getValue();
            AttributeDefinitionDraftBuilder resolvedBuilder = (AttributeDefinitionDraftBuilder)result.getKey();
            if (exception == null) {
                return CompletableFuture.completedFuture(resolvedBuilder.build());
            }
            String errorMessage = String.format("Failed to resolve references on attribute definition with name '%s'.", attributeDefinitionDraft.getName());
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage, exception.getCause()));
        });
    }

    @Nonnull
    private CompletionStage<AttributeDefinitionDraftBuilder> resolveNestedAttributeTypeReferences(@Nonnull AttributeDefinitionDraftBuilder attributeDefinitionDraftBuilder) {
        AttributeType attributeType = attributeDefinitionDraftBuilder.getAttributeType();
        if (attributeType instanceof NestedAttributeType) {
            return this.resolveNestedTypeReference((NestedAttributeType)attributeType).thenApply(x$0 -> (AttributeDefinitionDraftBuilder)attributeDefinitionDraftBuilder.attributeType(x$0));
        }
        if (attributeType instanceof SetAttributeType) {
            SetAttributeType setAttributeType = (SetAttributeType)attributeType;
            AttributeType elementType = setAttributeType.getElementType();
            AtomicInteger maxDepth = new AtomicInteger();
            AttributeType nestedAttributeType = elementType;
            if (elementType instanceof SetAttributeType) {
                maxDepth.incrementAndGet();
                nestedAttributeType = this.getNestedAttributeType((SetAttributeType)elementType, maxDepth);
            }
            if (nestedAttributeType instanceof NestedAttributeType) {
                return this.resolveNestedAttributeTypeReferences(attributeDefinitionDraftBuilder, maxDepth, (NestedAttributeType)nestedAttributeType);
            }
        }
        return CompletableFuture.completedFuture(attributeDefinitionDraftBuilder);
    }

    @Nonnull
    private CompletionStage<AttributeDefinitionDraftBuilder> resolveNestedAttributeTypeReferences(@Nonnull AttributeDefinitionDraftBuilder attributeDefinitionDraftBuilder, AtomicInteger maxDepth, @Nonnull NestedAttributeType nestedAttributeType) {
        return this.resolveNestedTypeReference(nestedAttributeType).thenApply(resolvedNestedAttributeType -> {
            SetAttributeType setAttributeTypeChain = SetAttributeType.of((AttributeType)resolvedNestedAttributeType);
            for (int i = 0; i < maxDepth.get(); ++i) {
                setAttributeTypeChain = SetAttributeType.of((AttributeType)setAttributeTypeChain);
            }
            return setAttributeTypeChain;
        }).thenApply(x$0 -> (AttributeDefinitionDraftBuilder)attributeDefinitionDraftBuilder.attributeType(x$0));
    }

    @Nullable
    private AttributeType getNestedAttributeType(@Nonnull SetAttributeType setAttributeType, @Nonnull AtomicInteger maxDepth) {
        AttributeType elementType = setAttributeType.getElementType();
        if (elementType instanceof SetAttributeType) {
            maxDepth.incrementAndGet();
            return this.getNestedAttributeType((SetAttributeType)elementType, maxDepth);
        }
        return elementType;
    }

    @Nonnull
    private CompletionStage<NestedAttributeType> resolveNestedTypeReference(@Nonnull NestedAttributeType nestedAttributeType) {
        Reference typeReference = nestedAttributeType.getTypeReference();
        return this.resolveProductTypeReference((Reference<ProductType>)typeReference).thenApply(optionalResolvedReference -> optionalResolvedReference.map(NestedAttributeType::of).orElse(nestedAttributeType));
    }

    @Nonnull
    private CompletionStage<Optional<Reference<ProductType>>> resolveProductTypeReference(@Nonnull Reference<ProductType> typeReference) {
        String resourceKey;
        try {
            resourceKey = AttributeDefinitionReferenceResolver.getIdFromReference(typeReference);
        }
        catch (ReferenceResolutionException exception) {
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException("Failed to resolve NestedType productType reference.", exception));
        }
        return this.productTypeService.fetchCachedProductTypeId(resourceKey).thenApply(optionalId -> optionalId.map(ProductType::referenceOfId));
    }
}

