/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.shoppinglists.LineItem;
import io.sphere.sdk.shoppinglists.LineItemDraft;
import io.sphere.sdk.shoppinglists.LineItemDraftBuilder;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.ShoppingListDraftBuilder;
import io.sphere.sdk.shoppinglists.TextLineItem;
import io.sphere.sdk.shoppinglists.TextLineItemDraft;
import io.sphere.sdk.shoppinglists.TextLineItemDraftBuilder;
import io.sphere.sdk.shoppinglists.queries.ShoppingListQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ShoppingListReferenceResolutionUtils {
    @Nonnull
    public static List<ShoppingListDraft> mapToShoppingListDrafts(@Nonnull List<ShoppingList> shoppingLists, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return shoppingLists.stream().filter(Objects::nonNull).map(shoppingList -> ShoppingListReferenceResolutionUtils.mapToShoppingListDraft(shoppingList, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    public static ShoppingListDraft mapToShoppingListDraft(@Nonnull ShoppingList shoppingList, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return ((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)((ShoppingListDraftBuilder)ShoppingListDraftBuilder.of((LocalizedString)shoppingList.getName()).description(shoppingList.getDescription())).key(shoppingList.getKey())).customer(SyncUtils.getResourceIdentifierWithKey(shoppingList.getCustomer(), referenceIdToKeyCache))).slug(shoppingList.getSlug())).lineItems(ShoppingListReferenceResolutionUtils.mapToLineItemDrafts(shoppingList.getLineItems(), referenceIdToKeyCache))).textLineItems(ShoppingListReferenceResolutionUtils.mapToTextLineItemDrafts(shoppingList.getTextLineItems(), referenceIdToKeyCache))).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(shoppingList, referenceIdToKeyCache))).deleteDaysAfterLastModification(shoppingList.getDeleteDaysAfterLastModification())).anonymousId(shoppingList.getAnonymousId())).build();
    }

    @Nullable
    private static List<LineItemDraft> mapToLineItemDrafts(@Nullable List<LineItem> lineItems, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (lineItems == null) {
            return null;
        }
        return lineItems.stream().filter(Objects::nonNull).map(lineItem -> ShoppingListReferenceResolutionUtils.mapToLineItemDraft(lineItem, referenceIdToKeyCache)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static LineItemDraft mapToLineItemDraft(@Nonnull LineItem lineItem, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (lineItem.getVariant() != null) {
            return ((LineItemDraftBuilder)((LineItemDraftBuilder)LineItemDraftBuilder.ofSku((String)lineItem.getVariant().getSku(), (Long)lineItem.getQuantity()).addedAt(lineItem.getAddedAt())).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(lineItem.getCustom(), referenceIdToKeyCache))).build();
        }
        return null;
    }

    @Nullable
    private static List<TextLineItemDraft> mapToTextLineItemDrafts(@Nullable List<TextLineItem> textLineItems, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (textLineItems == null) {
            return null;
        }
        return textLineItems.stream().filter(Objects::nonNull).map(textLineItem -> ShoppingListReferenceResolutionUtils.mapToTextLineItemDraft(textLineItem, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static TextLineItemDraft mapToTextLineItemDraft(@Nonnull TextLineItem textLineItem, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return TextLineItemDraftBuilder.of((LocalizedString)textLineItem.getName(), (Long)textLineItem.getQuantity()).description(textLineItem.getDescription()).addedAt(textLineItem.getAddedAt()).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(textLineItem.getCustom(), referenceIdToKeyCache)).build();
    }

    public static ShoppingListQuery buildShoppingListQuery() {
        return (ShoppingListQuery)ShoppingListQuery.of().plusExpansionPaths(ExpansionPath.of((String)"lineItems[*].variant"));
    }

    private ShoppingListReferenceResolutionUtils() {
    }
}

