/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.utils;

import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import io.sphere.sdk.states.StateDraftBuilder;
import io.sphere.sdk.states.StateType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class StateReferenceResolutionUtils {
    @Nonnull
    public static List<StateDraft> mapToStateDrafts(@Nonnull List<State> states, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return states.stream().filter(Objects::nonNull).map(state -> {
            Set<Reference<State>> newTransitions = StateReferenceResolutionUtils.replaceTransitionIdsWithKeys(state, referenceIdToKeyCache);
            return ((StateDraftBuilder)((StateDraftBuilder)((StateDraftBuilder)((StateDraftBuilder)((StateDraftBuilder)StateDraftBuilder.of((String)state.getKey(), (StateType)state.getType()).name(state.getName())).description(state.getDescription())).initial(state.isInitial())).roles(state.getRoles())).transitions(newTransitions)).build();
        }).collect(Collectors.toList());
    }

    private static Set<Reference<State>> replaceTransitionIdsWithKeys(@Nonnull State state, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        Set transitions = state.getTransitions();
        HashSet<Reference<State>> newTransitions = new HashSet<Reference<State>>();
        if (transitions != null && !transitions.isEmpty()) {
            transitions.forEach(transition -> newTransitions.add(SyncUtils.getReferenceWithKeyReplaced(transition, () -> State.referenceOfId((String)referenceIdToKeyCache.get(transition.getId())), referenceIdToKeyCache)));
        }
        return newTransitions;
    }

    private StateReferenceResolutionUtils() {
    }
}

