/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories;

import com.commercetools.sync.commons.BaseSyncOptionsBuilder;
import com.commercetools.sync.inventories.InventorySyncOptions;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import javax.annotation.Nonnull;

public final class InventorySyncOptionsBuilder
extends BaseSyncOptionsBuilder<InventorySyncOptionsBuilder, InventorySyncOptions, InventoryEntry, InventoryEntryDraft, InventoryEntry> {
    static final int BATCH_SIZE_DEFAULT = 150;
    static final boolean ENSURE_CHANNELS_DEFAULT = false;
    private boolean ensureChannels = false;

    private InventorySyncOptionsBuilder(@Nonnull SphereClient ctpClient) {
        this.ctpClient = ctpClient;
    }

    public static InventorySyncOptionsBuilder of(@Nonnull SphereClient ctpClient) {
        return (InventorySyncOptionsBuilder)new InventorySyncOptionsBuilder(ctpClient).batchSize(150);
    }

    public InventorySyncOptionsBuilder ensureChannels(boolean ensureChannels) {
        this.ensureChannels = ensureChannels;
        return this;
    }

    @Override
    public InventorySyncOptions build() {
        return new InventorySyncOptions(this.ctpClient, this.errorCallback, this.warningCallback, this.batchSize, this.ensureChannels, this.beforeUpdateCallback, this.beforeCreateCallback, this.cacheSize);
    }

    @Override
    protected InventorySyncOptionsBuilder getThis() {
        return this;
    }
}

