/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.EnumValuesUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.EnumValue;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.commands.updateactions.AddEnumValue;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeEnumValueOrder;
import io.sphere.sdk.producttypes.commands.updateactions.ChangePlainEnumValueLabel;
import io.sphere.sdk.producttypes.commands.updateactions.RemoveEnumValues;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PlainEnumValueUpdateActionUtils {
    @Nonnull
    public static List<UpdateAction<ProductType>> buildEnumValuesUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull List<EnumValue> oldEnumValues, @Nullable List<EnumValue> newEnumValues) {
        return EnumValuesUpdateActionUtils.buildActions(attributeDefinitionName, oldEnumValues, newEnumValues, RemoveEnumValues::of, PlainEnumValueUpdateActionUtils::buildEnumValueUpdateActions, AddEnumValue::of, ChangeEnumValueOrder::of, null);
    }

    @Nonnull
    public static List<UpdateAction<ProductType>> buildEnumValueUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull EnumValue oldEnumValue, @Nonnull EnumValue newEnumValue) {
        return OptionalUtils.filterEmptyOptionals(PlainEnumValueUpdateActionUtils.buildChangeLabelAction(attributeDefinitionName, oldEnumValue, newEnumValue));
    }

    @Nonnull
    public static Optional<UpdateAction<ProductType>> buildChangeLabelAction(@Nonnull String attributeDefinitionName, @Nonnull EnumValue oldEnumValue, @Nonnull EnumValue newEnumValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldEnumValue.getLabel(), newEnumValue.getLabel(), () -> ChangePlainEnumValueLabel.of((String)attributeDefinitionName, (EnumValue)newEnumValue));
    }

    private PlainEnumValueUpdateActionUtils() {
    }
}

