/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.models.WaitingToBeResolved;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.services.UnresolvedReferencesService;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.customobjects.CustomObject;
import io.sphere.sdk.customobjects.CustomObjectDraft;
import io.sphere.sdk.customobjects.commands.CustomObjectDeleteCommand;
import io.sphere.sdk.customobjects.commands.CustomObjectUpsertCommand;
import io.sphere.sdk.customobjects.queries.CustomObjectQuery;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;

public class UnresolvedReferencesServiceImpl<T extends WaitingToBeResolved>
implements UnresolvedReferencesService<T> {
    private final BaseSyncOptions syncOptions;
    private static final String SAVE_FAILED = "Failed to save CustomObject with key: '%s' (hash of product key: '%s').";
    private static final String DELETE_FAILED = "Failed to delete CustomObject with key: '%s' (hash of product key: '%s').";
    public static final String CUSTOM_OBJECT_PRODUCT_CONTAINER_KEY = "commercetools-sync-java.UnresolvedReferencesService.productDrafts";
    public static final String CUSTOM_OBJECT_CATEGORY_CONTAINER_KEY = "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts";
    public static final String CUSTOM_OBJECT_TRANSITION_CONTAINER_KEY = "commercetools-sync-java.UnresolvedTransitionsService.stateDrafts";

    public UnresolvedReferencesServiceImpl(@Nonnull BaseSyncOptions baseSyncOptions) {
        this.syncOptions = baseSyncOptions;
    }

    @Nonnull
    private String hash(@Nullable String customObjectKey) {
        return DigestUtils.sha1Hex((String)customObjectKey);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<T>> fetch(@Nonnull Set<String> keys, @Nonnull String containerKey, @Nonnull Class<T> clazz) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        int CHUNK_SIZE = 250;
        Set hashedKeys = keys.stream().map(this::hash).collect(Collectors.toSet());
        List chunkedKeys = ChunkUtils.chunk(hashedKeys, 250);
        List chunkedRequests = chunkedKeys.stream().map(_keys -> (CustomObjectQuery)CustomObjectQuery.of((Class)clazz).byContainer(containerKey).plusPredicates(p -> p.key().isIn((Iterable)_keys))).collect(Collectors.toList());
        return ((CompletableFuture)ChunkUtils.executeChunks(this.syncOptions.getCtpClient(), chunkedRequests).thenApply(ChunkUtils::flattenPagedQueryResults)).thenApply(customObjects -> customObjects.stream().map(CustomObject::getValue).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<T>> save(@Nonnull T draft, @Nonnull String containerKey, @Nonnull Class<T> clazz) {
        CustomObjectDraft customObjectDraft = CustomObjectDraft.ofUnversionedUpsert((String)containerKey, (String)this.hash(draft.getKey()), draft, clazz);
        return this.syncOptions.getCtpClient().execute((SphereRequest)CustomObjectUpsertCommand.of((CustomObjectDraft)customObjectDraft)).handle((resource, exception) -> {
            if (exception == null) {
                return Optional.of((WaitingToBeResolved)resource.getValue());
            }
            this.syncOptions.applyErrorCallback(new SyncException(String.format(SAVE_FAILED, customObjectDraft.getKey(), draft.getKey()), (Throwable)exception));
            return Optional.empty();
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<T>> delete(@Nonnull String key, @Nonnull String containerKey, @Nonnull Class<T> clazz) {
        return this.syncOptions.getCtpClient().execute((SphereRequest)CustomObjectDeleteCommand.of((String)containerKey, (String)this.hash(key), clazz)).handle((resource, exception) -> {
            if (exception == null) {
                return Optional.of(resource.getValue());
            }
            this.syncOptions.applyErrorCallback(new SyncException(String.format(DELETE_FAILED, this.hash(key), key), (Throwable)exception));
            return Optional.empty();
        });
    }
}

