/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.helpers;

import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.helpers.ShoppingListSyncStatistics;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.shoppinglists.LineItemDraft;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.TextLineItemDraft;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ShoppingListBatchValidator
extends BaseBatchValidator<ShoppingListDraft, ShoppingListSyncOptions, ShoppingListSyncStatistics> {
    public static final String SHOPPING_LIST_DRAFT_KEY_NOT_SET = "ShoppingListDraft with name: %s doesn't have a key. Please make sure all shopping list drafts have keys.";
    public static final String SHOPPING_LIST_DRAFT_IS_NULL = "ShoppingListDraft is null.";
    public static final String SHOPPING_LIST_DRAFT_NAME_NOT_SET = "ShoppingListDraft with key: %s doesn't have a name. Please make sure all shopping list drafts have names.";
    static final String LINE_ITEM_DRAFT_IS_NULL = "LineItemDraft at position '%d' of ShoppingListDraft with key '%s' is null.";
    static final String LINE_ITEM_DRAFT_SKU_NOT_SET = "LineItemDraft at position '%d' of ShoppingListDraft with key '%s' has no SKU set. Please make sure all lineItems have SKUs.";
    static final String TEXT_LINE_ITEM_DRAFT_IS_NULL = "TextLineItemDraft at position '%d' of ShoppingListDraft with key '%s' is null.";
    static final String TEXT_LINE_ITEM_DRAFT_NAME_NOT_SET = "TextLineItemDraft at position '%d' of ShoppingListDraft with key '%s' has no name set. Please make sure all textLineItems have names.";

    public ShoppingListBatchValidator(@Nonnull ShoppingListSyncOptions syncOptions, @Nonnull ShoppingListSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<ShoppingListDraft>, ReferencedKeys> validateAndCollectReferencedKeys(@Nonnull List<ShoppingListDraft> shoppingListDrafts) {
        ReferencedKeys referencedKeys = new ReferencedKeys();
        Set validDrafts = shoppingListDrafts.stream().filter(this::isValidShoppingListDraft).peek(shoppingListDraft -> this.collectReferencedKeys(referencedKeys, (ShoppingListDraft)shoppingListDraft)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, (Object)referencedKeys);
    }

    private boolean isValidShoppingListDraft(@Nullable ShoppingListDraft shoppingListDraft) {
        if (shoppingListDraft == null) {
            this.handleError(SHOPPING_LIST_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)shoppingListDraft.getKey())) {
            this.handleError(String.format(SHOPPING_LIST_DRAFT_KEY_NOT_SET, shoppingListDraft.getName()));
        } else if (this.isNullOrEmptyLocalizedString(shoppingListDraft.getName())) {
            this.handleError(String.format(SHOPPING_LIST_DRAFT_NAME_NOT_SET, shoppingListDraft.getKey()));
        } else {
            List<String> draftErrors = this.getErrorsInAllLineItemsAndTextLineItems(shoppingListDraft);
            if (!draftErrors.isEmpty()) {
                String concatenatedErrors = String.join((CharSequence)",", draftErrors);
                this.handleError(concatenatedErrors);
            } else {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    private List<String> getErrorsInAllLineItemsAndTextLineItems(@Nonnull ShoppingListDraft shoppingListDraft) {
        int i;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (shoppingListDraft.getLineItems() != null) {
            List lineItemDrafts = shoppingListDraft.getLineItems();
            for (i = 0; i < lineItemDrafts.size(); ++i) {
                errorMessages.addAll(this.getLineItemDraftErrorsInAllLineItems((LineItemDraft)lineItemDrafts.get(i), i, shoppingListDraft.getKey()));
            }
        }
        if (shoppingListDraft.getTextLineItems() != null) {
            List textLineItems = shoppingListDraft.getTextLineItems();
            for (i = 0; i < textLineItems.size(); ++i) {
                errorMessages.addAll(this.getTextLineItemDraftErrorsInAllTextLineItems((TextLineItemDraft)textLineItems.get(i), i, shoppingListDraft.getKey()));
            }
        }
        return errorMessages;
    }

    @Nonnull
    private List<String> getLineItemDraftErrorsInAllLineItems(@Nullable LineItemDraft lineItemDraft, int itemPosition, @Nonnull String shoppingListDraftKey) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (lineItemDraft != null) {
            if (StringUtils.isBlank((CharSequence)lineItemDraft.getSku())) {
                errorMessages.add(String.format(LINE_ITEM_DRAFT_SKU_NOT_SET, itemPosition, shoppingListDraftKey));
            }
        } else {
            errorMessages.add(String.format(LINE_ITEM_DRAFT_IS_NULL, itemPosition, shoppingListDraftKey));
        }
        return errorMessages;
    }

    @Nonnull
    private List<String> getTextLineItemDraftErrorsInAllTextLineItems(@Nullable TextLineItemDraft textLineItemDraft, int itemPosition, @Nonnull String shoppingListDraftKey) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (textLineItemDraft != null) {
            if (this.isNullOrEmptyLocalizedString(textLineItemDraft.getName())) {
                errorMessages.add(String.format(TEXT_LINE_ITEM_DRAFT_NAME_NOT_SET, itemPosition, shoppingListDraftKey));
            }
        } else {
            errorMessages.add(String.format(TEXT_LINE_ITEM_DRAFT_IS_NULL, itemPosition, shoppingListDraftKey));
        }
        return errorMessages;
    }

    private boolean isNullOrEmptyLocalizedString(@Nullable LocalizedString localizedString) {
        return localizedString == null || localizedString.getLocales().isEmpty();
    }

    private void collectReferencedKeys(@Nonnull ReferencedKeys referencedKeys, @Nonnull ShoppingListDraft shoppingListDraft) {
        this.collectReferencedKeyFromResourceIdentifier(shoppingListDraft.getCustomer(), referencedKeys.customerKeys::add);
        this.collectReferencedKeyFromCustomFieldsDraft(shoppingListDraft.getCustom(), referencedKeys.typeKeys::add);
        this.collectReferencedKeysInLineItems(referencedKeys, shoppingListDraft);
        this.collectReferencedKeysInTextLineItems(referencedKeys, shoppingListDraft);
    }

    private void collectReferencedKeysInLineItems(@Nonnull ReferencedKeys referencedKeys, @Nonnull ShoppingListDraft shoppingListDraft) {
        if (shoppingListDraft.getLineItems() == null) {
            return;
        }
        shoppingListDraft.getLineItems().forEach(lineItemDraft -> this.collectReferencedKeyFromCustomFieldsDraft(lineItemDraft.getCustom(), referencedKeys.typeKeys::add));
    }

    private void collectReferencedKeysInTextLineItems(@Nonnull ReferencedKeys referencedKeys, @Nonnull ShoppingListDraft shoppingListDraft) {
        if (shoppingListDraft.getTextLineItems() == null) {
            return;
        }
        shoppingListDraft.getTextLineItems().forEach(textLineItemDraft -> this.collectReferencedKeyFromCustomFieldsDraft(textLineItemDraft.getCustom(), referencedKeys.typeKeys::add));
    }

    public static class ReferencedKeys {
        private final Set<String> customerKeys = new HashSet<String>();
        private final Set<String> typeKeys = new HashSet<String>();

        public Set<String> getTypeKeys() {
            return this.typeKeys;
        }

        public Set<String> getCustomerKeys() {
            return this.customerKeys;
        }
    }
}

