/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.models;

import com.commercetools.sync.commons.helpers.GraphQlBaseRequestImpl;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.models.ResourceKeyIdGraphQlResult;
import io.sphere.sdk.http.HttpResponse;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class FetchCustomObjectsGraphQlRequest
extends GraphQlBaseRequestImpl<ResourceKeyIdGraphQlResult> {
    private final String container;
    private final Instant lastModifiedAt;
    private final String resourceName = GraphQlQueryResources.CUSTOM_OBJECTS.getName();

    public FetchCustomObjectsGraphQlRequest(@Nonnull String container, @Nonnull Instant lastModifiedAt) {
        this.container = container;
        this.lastModifiedAt = lastModifiedAt;
    }

    @Nullable
    public ResourceKeyIdGraphQlResult deserialize(HttpResponse httpResponse) {
        return this.deserializeWithResourceName(httpResponse, this.resourceName, ResourceKeyIdGraphQlResult.class);
    }

    @Override
    @Nonnull
    protected String buildQueryString() {
        return String.format("%s(container: \\\"%s\\\", limit: %d, where: \\\"%s\\\", sort: [\\\"id asc\\\"]) { results { id key } }", this.resourceName, this.container, this.limit, this.createWhereQuery());
    }

    @Nonnull
    private String createWhereQuery() {
        String whereQuery = String.format("lastModifiedAt < \\\\\\\"%s\\\\\\\"", this.lastModifiedAt);
        return StringUtils.isBlank((CharSequence)this.queryPredicate) ? whereQuery : String.format("%s AND %s", whereQuery, this.queryPredicate);
    }
}

