/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CommonTypeUpdateActionUtils {
    @Nonnull
    public static <T, S, U extends UpdateAction<T>> Optional<U> buildUpdateAction(@Nullable S oldObject, @Nullable S newObject, @Nonnull Supplier<U> updateActionSupplier) {
        return !Objects.equals(oldObject, newObject) ? Optional.ofNullable((UpdateAction)updateActionSupplier.get()) : Optional.empty();
    }

    @Nonnull
    public static <T, S extends ResourceIdentifier, U extends ResourceIdentifier, V extends UpdateAction<T>> Optional<V> buildUpdateActionForReferences(@Nullable S oldResourceIdentifier, @Nullable U newResourceIdentifier, @Nonnull Supplier<V> updateActionSupplier) {
        return !CommonTypeUpdateActionUtils.areResourceIdentifiersEqual(oldResourceIdentifier, newResourceIdentifier) ? Optional.ofNullable((UpdateAction)updateActionSupplier.get()) : Optional.empty();
    }

    public static <T extends ResourceIdentifier, S extends ResourceIdentifier> boolean areResourceIdentifiersEqual(@Nullable T oldResourceIdentifier, @Nullable S newResourceIdentifier) {
        String oldId = Optional.ofNullable(oldResourceIdentifier).map(ResourceIdentifier::getId).orElse(null);
        String newId = Optional.ofNullable(newResourceIdentifier).map(ResourceIdentifier::getId).orElse(null);
        return Objects.equals(oldId, newId);
    }

    @Nonnull
    public static <T, S, U extends UpdateAction<T>> List<U> buildUpdateActions(@Nullable S oldObject, @Nullable S newObject, @Nonnull Supplier<List<U>> updateActionSupplier) {
        return !Objects.equals(oldObject, newObject) ? updateActionSupplier.get() : Collections.emptyList();
    }

    private CommonTypeUpdateActionUtils() {
    }
}

