/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.service.impl;

import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.customers.service.CustomerTransformService;
import com.commercetools.sync.customers.utils.CustomerReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.customers.CustomerDraft;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.types.CustomFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CustomerTransformServiceImpl
extends BaseTransformServiceImpl
implements CustomerTransformService {
    public CustomerTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<CustomerDraft>> toCustomerDrafts(@Nonnull List<Customer> customers) {
        ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
        transformReferencesToRunParallel.add(this.transformCustomTypeReference(customers));
        transformReferencesToRunParallel.add(this.transformCustomerGroupReference(customers));
        return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> CustomerReferenceResolutionUtils.mapToCustomerDrafts(customers, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<Customer> customers) {
        Set<String> setOfTypeIds = customers.stream().map(Customer::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.TYPES);
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomerGroupReference(@Nonnull List<Customer> customers) {
        Set<String> customerGroupIds = customers.stream().map(Customer::getCustomerGroup).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(customerGroupIds, GraphQlQueryResources.CUSTOMER_GROUPS);
    }
}

