/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.products.ActionGroup;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import com.commercetools.sync.products.utils.ProductUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductProjection;
import io.sphere.sdk.products.commands.updateactions.RemoveVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductSyncUtils {
    private static final String REMOVE_VARIANT_ACTION_NAME = "removeVariant";
    private static final String SET_ATTRIBUTE_IN_ALL_VARIANTS_ACTION_NAME = "setAttributeInAllVariants";
    private static final String ADD_VARIANT_ACTION_NAME = "addVariant";
    private static final String CHANGE_MASTER_VARIANT_ACTION_NAME = "changeMasterVariant";

    @Nonnull
    public static List<UpdateAction<Product>> buildActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions, @Nonnull Map<String, AttributeMetaData> attributesMetaData) {
        SyncFilter syncFilter = syncOptions.getSyncFilter();
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>(OptionalUtils.filterEmptyOptionals(ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.NAME, () -> ProductUpdateActionUtils.buildChangeNameUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.DESCRIPTION, () -> ProductUpdateActionUtils.buildSetDescriptionUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SLUG, () -> ProductUpdateActionUtils.buildChangeSlugUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SEARCHKEYWORDS, () -> ProductUpdateActionUtils.buildSetSearchKeywordsUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METATITLE, () -> ProductUpdateActionUtils.buildSetMetaTitleUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METADESCRIPTION, () -> ProductUpdateActionUtils.buildSetMetaDescriptionUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METAKEYWORDS, () -> ProductUpdateActionUtils.buildSetMetaKeywordsUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.TAXCATEGORY, () -> ProductUpdateActionUtils.buildSetTaxCategoryUpdateAction(oldProduct, newProduct).map(action -> action)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.STATE, () -> ProductUpdateActionUtils.buildTransitionStateUpdateAction(oldProduct, newProduct).map(action -> action))));
        List productCategoryUpdateActions = ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.CATEGORIES, () -> ProductSyncUtils.buildCategoryActions(oldProduct, newProduct));
        updateActions.addAll(productCategoryUpdateActions);
        updateActions.addAll(ProductUpdateActionUtils.buildVariantsUpdateActions(oldProduct, newProduct, syncOptions, attributesMetaData));
        boolean hasNewUpdateActions = updateActions.size() > 0;
        ProductUpdateActionUtils.buildPublishOrUnpublishUpdateAction(oldProduct, newProduct, hasNewUpdateActions).ifPresent(updateActions::add);
        return ProductSyncUtils.prioritizeUpdateActions(updateActions, oldProduct.getMasterVariant().getId());
    }

    private static List<UpdateAction<Product>> prioritizeUpdateActions(List<UpdateAction<Product>> updateActions, Integer oldMasterVariantId) {
        RemoveVariant removeMasterVariantUpdateAction = RemoveVariant.ofVariantId((Integer)oldMasterVariantId);
        List<UpdateAction<Product>> removeVariantUpdateActionsNoMaster = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(REMOVE_VARIANT_ACTION_NAME) && !action.equals(removeMasterVariantUpdateAction));
        List<UpdateAction<Product>> sameForAllUpdateActions = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(SET_ATTRIBUTE_IN_ALL_VARIANTS_ACTION_NAME));
        List<UpdateAction<Product>> addVariantUpdateActions = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(ADD_VARIANT_ACTION_NAME));
        List<UpdateAction<Product>> changeMasterUpdateActions = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(CHANGE_MASTER_VARIANT_ACTION_NAME));
        List<UpdateAction<Product>> removeOldMasterVariantUpdateAction = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(REMOVE_VARIANT_ACTION_NAME) && action.equals(removeMasterVariantUpdateAction));
        ArrayList<UpdateAction<Product>> updateActionList = new ArrayList<UpdateAction<Product>>(removeVariantUpdateActionsNoMaster);
        updateActionList.addAll(sameForAllUpdateActions);
        updateActionList.addAll(addVariantUpdateActions);
        updateActionList.addAll(changeMasterUpdateActions);
        updateActionList.addAll(removeOldMasterVariantUpdateAction);
        updateActionList.addAll(updateActions);
        return updateActionList;
    }

    private static List<UpdateAction<Product>> getActionsByActionName(List<UpdateAction<Product>> updateActions, Predicate<UpdateAction<Product>> updateActionPredicate) {
        List<UpdateAction<Product>> filteredUpdateActions = CollectionUtils.emptyIfNull(updateActions).stream().filter(updateActionPredicate).collect(Collectors.toList());
        updateActions.removeAll(filteredUpdateActions);
        return filteredUpdateActions;
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildCategoryActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>();
        updateActions.addAll(ProductUpdateActionUtils.buildAddToCategoryUpdateActions(oldProduct, newProduct));
        updateActions.addAll(ProductUpdateActionUtils.buildSetCategoryOrderHintUpdateActions(oldProduct, newProduct));
        updateActions.addAll(ProductUpdateActionUtils.buildRemoveFromCategoryUpdateActions(oldProduct, newProduct));
        return updateActions;
    }

    private ProductSyncUtils() {
    }
}

