/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts;

import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.cartdiscounts.helpers.CartDiscountBatchValidator;
import com.commercetools.sync.cartdiscounts.helpers.CartDiscountReferenceResolver;
import com.commercetools.sync.cartdiscounts.helpers.CartDiscountSyncStatistics;
import com.commercetools.sync.cartdiscounts.utils.CartDiscountSyncUtils;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.CartDiscountService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.CartDiscountServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import io.sphere.sdk.cartdiscounts.CartDiscount;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.commands.UpdateAction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CartDiscountSync
extends BaseSync<CartDiscountDraft, CartDiscount, CartDiscountSyncStatistics, CartDiscountSyncOptions> {
    private static final String CTP_CART_DISCOUNT_FETCH_FAILED = "Failed to fetch existing cart discounts with keys: '%s'.";
    private static final String CTP_CART_DISCOUNT_UPDATE_FAILED = "Failed to update cart discount with key: '%s'. Reason: %s";
    private static final String FAILED_TO_PROCESS = "Failed to process the CartDiscountDraft with key:'%s'. Reason: %s";
    private final CartDiscountService cartDiscountService;
    private final TypeService typeService;
    private final CartDiscountReferenceResolver referenceResolver;
    private final CartDiscountBatchValidator batchValidator;

    public CartDiscountSync(@Nonnull CartDiscountSyncOptions cartDiscountSyncOptions) {
        this(cartDiscountSyncOptions, new TypeServiceImpl(cartDiscountSyncOptions), new CartDiscountServiceImpl(cartDiscountSyncOptions));
    }

    CartDiscountSync(@Nonnull CartDiscountSyncOptions cartDiscountSyncOptions, @Nonnull TypeService typeService, @Nonnull CartDiscountService cartDiscountService) {
        super(new CartDiscountSyncStatistics(), cartDiscountSyncOptions);
        this.cartDiscountService = cartDiscountService;
        this.typeService = typeService;
        this.referenceResolver = new CartDiscountReferenceResolver((CartDiscountSyncOptions)this.getSyncOptions(), typeService);
        this.batchValidator = new CartDiscountBatchValidator((CartDiscountSyncOptions)this.getSyncOptions(), (CartDiscountSyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<CartDiscountSyncStatistics> process(@Nonnull List<CartDiscountDraft> cartDiscountDrafts) {
        List batches = SyncUtils.batchElements(cartDiscountDrafts, ((CartDiscountSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture((CartDiscountSyncStatistics)this.statistics));
    }

    @Override
    protected CompletionStage<CartDiscountSyncStatistics> processBatch(@Nonnull List<CartDiscountDraft> batch) {
        ImmutablePair<Set<CartDiscountDraft>, Set<String>> result = this.batchValidator.validateAndCollectReferencedKeys(batch);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((CartDiscountSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture((CartDiscountSyncStatistics)this.statistics);
        }
        return this.typeService.cacheKeysToIds((Set)result.getRight()).handle(ImmutablePair::new).thenCompose(cachingResponse -> {
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of keys to ids.", cachingException, null, null, null, validDrafts.size());
                return CompletableFuture.completedFuture(null);
            }
            Set<String> keys = validDrafts.stream().map(CartDiscountDraft::getKey).collect(Collectors.toSet());
            return this.cartDiscountService.fetchMatchingCartDiscountsByKeys(keys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
                Set fetchedCartDiscounts = (Set)fetchResponse.getKey();
                Throwable exception = (Throwable)fetchResponse.getValue();
                if (exception != null) {
                    String errorMessage = String.format(CTP_CART_DISCOUNT_FETCH_FAILED, keys);
                    this.handleError(errorMessage, exception, null, null, null, keys.size());
                    return CompletableFuture.completedFuture(null);
                }
                return this.syncBatch(fetchedCartDiscounts, validDrafts);
            });
        }).thenApply(ignoredResult -> {
            ((CartDiscountSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (CartDiscountSyncStatistics)this.statistics;
        });
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<CartDiscount> oldCartDiscounts, @Nonnull Set<CartDiscountDraft> newCartDiscounts) {
        Map oldCartDiscountMap = oldCartDiscounts.stream().collect(Collectors.toMap(CartDiscount::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newCartDiscounts.stream().map(newCartDiscount -> this.referenceResolver.resolveReferences((CartDiscountDraft)newCartDiscount).thenCompose(resolvedDraft -> this.syncDraft(oldCartDiscountMap, (CartDiscountDraft)resolvedDraft)).exceptionally(completionException -> {
            String errorMessage = String.format(FAILED_TO_PROCESS, newCartDiscount.getKey(), completionException.getMessage());
            this.handleError(errorMessage, (Throwable)completionException, null, newCartDiscount, null, 1);
            return null;
        })).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Map<String, CartDiscount> oldCartDiscountMap, @Nonnull CartDiscountDraft newCartDiscount) {
        CartDiscount oldCartDiscount = oldCartDiscountMap.get(newCartDiscount.getKey());
        return Optional.ofNullable(oldCartDiscount).map(cartDiscount -> this.buildActionsAndUpdate(oldCartDiscount, newCartDiscount)).orElseGet(() -> this.applyCallbackAndCreate(newCartDiscount));
    }

    @Nonnull
    private CompletionStage<Void> buildActionsAndUpdate(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        List updateActions = CartDiscountSyncUtils.buildActions(oldCartDiscount, newCartDiscount, (CartDiscountSyncOptions)this.syncOptions);
        List<UpdateAction<CartDiscount>> updateActionsAfterCallback = ((CartDiscountSyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newCartDiscount, oldCartDiscount);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateCartDiscount(oldCartDiscount, newCartDiscount, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull CartDiscountDraft cartDiscountDraft) {
        return ((CartDiscountSyncOptions)this.syncOptions).applyBeforeCreateCallback(cartDiscountDraft).map(draft -> this.cartDiscountService.createCartDiscount((CartDiscountDraft)draft).thenAccept(cartDiscountOptional -> {
            if (cartDiscountOptional.isPresent()) {
                ((CartDiscountSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((CartDiscountSyncStatistics)this.statistics).incrementFailed();
            }
        })).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    @Nonnull
    private CompletionStage<Void> updateCartDiscount(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount, @Nonnull List<UpdateAction<CartDiscount>> updateActions) {
        return this.cartDiscountService.updateCartDiscount(oldCartDiscount, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return CartDiscountSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldCartDiscount, newCartDiscount), () -> {
                    String errorMessage = String.format(CTP_CART_DISCOUNT_UPDATE_FAILED, newCartDiscount.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, oldCartDiscount, newCartDiscount, updateActions, 1);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((CartDiscountSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        String key = oldCartDiscount.getKey();
        return this.cartDiscountService.fetchCartDiscount(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedCartDiscountOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_CART_DISCOUNT_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, oldCartDiscount, newCartDiscount, null, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedCartDiscountOptional.map(fetchedCartDiscount -> this.buildActionsAndUpdate((CartDiscount)fetchedCartDiscount, newCartDiscount)).orElseGet(() -> {
                String errorMessage = String.format(CTP_CART_DISCOUNT_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, oldCartDiscount, newCartDiscount, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }
}

