/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import io.sphere.sdk.cartdiscounts.CartDiscount;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.cartdiscounts.CartDiscountDraftBuilder;
import io.sphere.sdk.cartdiscounts.CartDiscountTarget;
import io.sphere.sdk.cartdiscounts.CartDiscountValue;
import io.sphere.sdk.models.LocalizedString;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CartDiscountReferenceResolutionUtils {
    @Nonnull
    public static List<CartDiscountDraft> mapToCartDiscountDrafts(@Nonnull List<CartDiscount> cartDiscounts, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return cartDiscounts.stream().map(cartDiscount -> CartDiscountReferenceResolutionUtils.mapToCartDiscountDraft(cartDiscount, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static CartDiscountDraft mapToCartDiscountDraft(@Nonnull CartDiscount cartDiscount, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return ((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)CartDiscountDraftBuilder.of((String)cartDiscount.getCartPredicate(), (LocalizedString)cartDiscount.getName(), (boolean)cartDiscount.isRequiringDiscountCode(), (String)cartDiscount.getSortOrder(), (CartDiscountTarget)cartDiscount.getTarget(), (CartDiscountValue)cartDiscount.getValue()).key(cartDiscount.getKey())).description(cartDiscount.getDescription())).active(cartDiscount.isActive())).validFrom(cartDiscount.getValidFrom())).validUntil(cartDiscount.getValidUntil())).stackingMode(cartDiscount.getStackingMode())).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(cartDiscount, referenceIdToKeyCache))).build();
    }

    private CartDiscountReferenceResolutionUtils() {
    }
}

