/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import io.sphere.sdk.client.ConcurrentModificationException;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Versioned;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseSync<T, S extends Versioned, U extends BaseSyncStatistics, V extends BaseSyncOptions> {
    protected final U statistics;
    protected final V syncOptions;

    protected BaseSync(@Nonnull U statistics, @Nonnull V syncOptions) {
        this.statistics = statistics;
        this.syncOptions = syncOptions;
    }

    protected abstract CompletionStage<U> process(@Nonnull List<T> var1);

    public CompletionStage<U> sync(@Nonnull List<T> resourceDrafts) {
        ((BaseSyncStatistics)this.statistics).startTimer();
        return this.process(resourceDrafts).thenApply(resultingStatistics -> {
            resultingStatistics.calculateProcessingTime();
            return resultingStatistics;
        });
    }

    @Nonnull
    public U getStatistics() {
        return this.statistics;
    }

    public V getSyncOptions() {
        return this.syncOptions;
    }

    protected CompletionStage<U> syncBatches(@Nonnull List<List<T>> batches, @Nonnull CompletionStage<U> result) {
        if (batches.isEmpty()) {
            return result;
        }
        List<T> firstBatch = batches.remove(0);
        return this.syncBatches(batches, result.thenCompose(subResult -> this.processBatch(firstBatch)));
    }

    protected abstract CompletionStage<U> processBatch(@Nonnull List<T> var1);

    protected static <S> S executeSupplierIfConcurrentModificationException(@Nonnull Throwable sphereException, @Nonnull Supplier<S> onConcurrentModificationSupplier, @Nonnull Supplier<S> onOtherExceptionSupplier) {
        Throwable completionExceptionCause = sphereException.getCause();
        if (completionExceptionCause instanceof ConcurrentModificationException) {
            return onConcurrentModificationSupplier.get();
        }
        return onOtherExceptionSupplier.get();
    }

    protected void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, S oldResource, T newResourceDraft, List<UpdateAction<S>> updateActions, int failedTimes) {
        SyncException syncException = exception != null ? new SyncException(errorMessage, exception) : new SyncException(errorMessage);
        ((BaseSyncOptions)this.syncOptions).applyErrorCallback(syncException, oldResource, newResourceDraft, updateActions);
        ((BaseSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

