/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.models;

import com.commercetools.sync.commons.helpers.GraphQlBaseRequestImpl;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.models.ResourceKeyIdGraphQlResult;
import io.sphere.sdk.http.HttpResponse;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ResourceIdsGraphQlRequest
extends GraphQlBaseRequestImpl<ResourceKeyIdGraphQlResult> {
    protected final Set<String> idsToSearch;
    protected final GraphQlQueryResources resource;

    public ResourceIdsGraphQlRequest(@Nonnull Set<String> idsToSearch, @Nonnull GraphQlQueryResources resource) {
        this.idsToSearch = Objects.requireNonNull(idsToSearch);
        this.resource = resource;
    }

    @Nullable
    public ResourceKeyIdGraphQlResult deserialize(HttpResponse httpResponse) {
        return this.deserializeWithResourceName(httpResponse, this.resource.getName(), ResourceKeyIdGraphQlResult.class);
    }

    @Override
    @Nonnull
    protected String buildQueryString() {
        return String.format("%s(limit: %d, where: \\\"%s\\\", sort: [\\\"id asc\\\"]) { results { id key } }", this.resource.getName(), this.limit, this.createWhereQuery(this.idsToSearch));
    }

    @Nonnull
    private String createWhereQuery(@Nonnull Set<String> ids) {
        String backslashQuote = "\\\\\\\"";
        String commaSeparatedIds = ids.stream().filter(id -> !StringUtils.isBlank((CharSequence)id)).collect(Collectors.joining(String.format("%s, %s", "\\\\\\\"", "\\\\\\\""), "\\\\\\\"", "\\\\\\\""));
        String whereQuery = this.createWhereQuery(commaSeparatedIds);
        return StringUtils.isBlank((CharSequence)this.queryPredicate) ? whereQuery : String.format("%s AND %s", whereQuery, this.queryPredicate);
    }

    @Nonnull
    private String createWhereQuery(@Nonnull String commaSeparatedIds) {
        return String.format("id in (%s)", commaSeparatedIds);
    }
}

