/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.client.ApiInternalLoggerFactory;
import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.defaultconfig.ApiRootBuilder;
import com.commercetools.api.defaultconfig.ServiceRegion;
import com.commercetools.compat.CompatSphereClient;
import io.sphere.sdk.client.BlockingSphereClient;
import io.sphere.sdk.client.SphereClient;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.error.ApiClientException;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.event.Level;

public final class ClientV2ConfigurationUtils {
    protected static SphereClient createClient(@Nonnull String projectKey, @Nonnull ClientCredentials clientCredentials, @Nonnull ServiceRegion serviceRegion) {
        ProjectApiRoot apiRoot = ApiRootBuilder.of().defaultClient(clientCredentials, serviceRegion.getOAuthTokenUrl(), serviceRegion.getApiUrl()).withInternalLoggerFactory(ApiInternalLoggerFactory::get, Level.INFO, Level.INFO, Level.ERROR, Collections.singletonMap(ApiClientException.class, Level.INFO)).withErrorMiddleware(ErrorMiddleware.ExceptionMode.UNWRAP_COMPLETION_EXCEPTION).addNotFoundExceptionMiddleware(Collections.singleton(ApiHttpMethod.GET)).withRetryMiddleware(5, 200L, 60000L, Arrays.asList(500, 502, 503, 504), null, options -> options).build(projectKey);
        return CompatSphereClient.of((ProjectApiRoot)apiRoot);
    }

    public static SphereClient createClient(@Nonnull String projectKey, @Nonnull ClientCredentials clientCredentials, @Nonnull ServiceRegion serviceRegion, long timeout, @Nonnull TimeUnit timeUnit) {
        return BlockingSphereClient.of((SphereClient)ClientV2ConfigurationUtils.createClient(projectKey, clientCredentials, serviceRegion), (long)timeout, (TimeUnit)timeUnit);
    }

    private ClientV2ConfigurationUtils() {
    }
}

