/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.TriFunction;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.WithKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class EnumValuesUpdateActionUtils {
    @Nonnull
    public static <T extends WithKey, U> List<UpdateAction<U>> buildActions(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nullable List<T> newEnumValues, @Nullable BiFunction<String, List<String>, UpdateAction<U>> removeEnumCallback, @Nullable TriFunction<String, T, T, List<UpdateAction<U>>> matchingEnumCallback, @Nullable BiFunction<String, T, UpdateAction<U>> addEnumCallback, @Nullable BiFunction<String, List<T>, UpdateAction<U>> changeOrderEnumCallback, @Nullable BiFunction<String, List<String>, UpdateAction<U>> changeOrderWithKeysEnumCallback) {
        if (newEnumValues != null) {
            return EnumValuesUpdateActionUtils.buildUpdateActions(definitionName, oldEnumValues, newEnumValues, removeEnumCallback, matchingEnumCallback, addEnumCallback, changeOrderEnumCallback, changeOrderWithKeysEnumCallback);
        }
        if (removeEnumCallback != null) {
            return EnumValuesUpdateActionUtils.buildRemoveEnumValuesUpdateAction(definitionName, oldEnumValues, null, removeEnumCallback).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static <T extends WithKey, U> List<UpdateAction<U>> buildUpdateActions(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nullable BiFunction<String, List<String>, UpdateAction<U>> removeEnumValuesUpdateActionCallback, @Nullable TriFunction<String, T, T, List<UpdateAction<U>>> matchingEnumCallback, @Nullable BiFunction<String, T, UpdateAction<U>> addEnumCallback, @Nullable BiFunction<String, List<T>, UpdateAction<U>> changeOrderEnumCallback, @Nullable BiFunction<String, List<String>, UpdateAction<U>> changeOrderWithKeysEnumCallback) {
        Optional<UpdateAction<List>> removeEnumValuesUpdateAction = EnumValuesUpdateActionUtils.getRemoveEnumValuesUpdateAction(definitionName, oldEnumValues, newEnumValues, removeEnumValuesUpdateActionCallback);
        List<UpdateAction<U>> matchingEnumValuesUpdateActions = EnumValuesUpdateActionUtils.getMatchingEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, matchingEnumCallback);
        List<UpdateAction<U>> addEnumValuesUpdateActions = EnumValuesUpdateActionUtils.getAddEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, addEnumCallback);
        Optional<UpdateAction<List>> changeEnumValuesOrderUpdateAction = EnumValuesUpdateActionUtils.getChangeEnumValuesOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderEnumCallback);
        Optional<UpdateAction<List>> changeEnumValuesWithKeysOrderUpdateActions = EnumValuesUpdateActionUtils.getChangeEnumValuesWithKeysOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderWithKeysEnumCallback);
        return Stream.of(removeEnumValuesUpdateAction.map(Collections::singletonList).orElse(Collections.emptyList()), matchingEnumValuesUpdateActions, addEnumValuesUpdateActions, changeEnumValuesOrderUpdateAction.map(Collections::singletonList).orElse(Collections.emptyList()), changeEnumValuesWithKeysOrderUpdateActions.map(Collections::singletonList).orElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static <T extends WithKey, U> Optional<UpdateAction<U>> getChangeEnumValuesWithKeysOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nullable BiFunction<String, List<String>, UpdateAction<U>> changeOrderWithKeysEnumCallback) {
        return changeOrderWithKeysEnumCallback == null ? Optional.empty() : EnumValuesUpdateActionUtils.buildChangeEnumValuesWithKeysOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderWithKeysEnumCallback);
    }

    @Nonnull
    private static <T extends WithKey, U> Optional<UpdateAction<U>> getChangeEnumValuesOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nullable BiFunction<String, List<T>, UpdateAction<U>> changeOrderEnumCallback) {
        return changeOrderEnumCallback == null ? Optional.empty() : EnumValuesUpdateActionUtils.buildChangeEnumValuesOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderEnumCallback);
    }

    @Nonnull
    private static <T extends WithKey, U> List<UpdateAction<U>> getAddEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nullable BiFunction<String, T, UpdateAction<U>> addEnumCallback) {
        return addEnumCallback == null ? Collections.emptyList() : EnumValuesUpdateActionUtils.buildAddEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, addEnumCallback);
    }

    @Nonnull
    private static <T extends WithKey, U> List<UpdateAction<U>> getMatchingEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nullable TriFunction<String, T, T, List<UpdateAction<U>>> matchingEnumCallback) {
        return matchingEnumCallback == null ? Collections.emptyList() : EnumValuesUpdateActionUtils.buildMatchingEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, matchingEnumCallback);
    }

    @Nonnull
    private static <T extends WithKey, U> Optional<UpdateAction<U>> getRemoveEnumValuesUpdateAction(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nullable BiFunction<String, List<String>, UpdateAction<U>> removeEnumValuesUpdateActionCallback) {
        return removeEnumValuesUpdateActionCallback == null ? Optional.empty() : EnumValuesUpdateActionUtils.buildRemoveEnumValuesUpdateAction(definitionName, oldEnumValues, newEnumValues, removeEnumValuesUpdateActionCallback);
    }

    @Nonnull
    static <T extends WithKey, U> Optional<UpdateAction<U>> buildChangeEnumValuesOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nonnull BiFunction<String, List<T>, UpdateAction<U>> changeOrderEnumCallback) {
        Pair<List<String>, List<String>> keysPair = EnumValuesUpdateActionUtils.getAllKeysAndNewKeysPair(oldEnumValues, newEnumValues);
        return CommonTypeUpdateActionUtils.buildUpdateAction((List)keysPair.getLeft(), (List)keysPair.getRight(), () -> (UpdateAction)changeOrderEnumCallback.apply(definitionName, newEnumValues));
    }

    @Nonnull
    private static <T extends WithKey, U> Optional<UpdateAction<U>> buildChangeEnumValuesWithKeysOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nonnull BiFunction<String, List<String>, UpdateAction<U>> changeOrderEnumCallback) {
        Pair<List<String>, List<String>> keysPair = EnumValuesUpdateActionUtils.getAllKeysAndNewKeysPair(oldEnumValues, newEnumValues);
        return CommonTypeUpdateActionUtils.buildUpdateAction((List)keysPair.getLeft(), (List)keysPair.getRight(), () -> (UpdateAction)changeOrderEnumCallback.apply(definitionName, (List)keysPair.getRight()));
    }

    @Nonnull
    private static <T extends WithKey> Pair<List<String>, List<String>> getAllKeysAndNewKeysPair(@Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues) {
        List newKeys = newEnumValues.stream().map(WithKey::getKey).collect(Collectors.toList());
        List existingKeys = oldEnumValues.stream().map(WithKey::getKey).filter(newKeys::contains).collect(Collectors.toList());
        List notExistingKeys = newKeys.stream().filter(newKey -> !existingKeys.contains(newKey)).collect(Collectors.toList());
        List allKeys = Stream.concat(existingKeys.stream(), notExistingKeys.stream()).collect(Collectors.toList());
        return ImmutablePair.of(allKeys, newKeys);
    }

    @Nonnull
    static <T extends WithKey, U> List<UpdateAction<U>> buildAddEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nonnull BiFunction<String, T, UpdateAction<U>> addEnumCallback) {
        Map oldEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, oldEnumValues);
        Map<String, T> newEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, newEnumValues);
        return newEnumValuesKeyMap.values().stream().filter(newEnumValue -> !oldEnumValuesKeyMap.containsKey(newEnumValue.getKey())).map(newEnumValue -> (UpdateAction)addEnumCallback.apply(definitionName, newEnumValue)).collect(Collectors.toList());
    }

    @Nonnull
    static <T extends WithKey, U> Optional<UpdateAction<U>> buildRemoveEnumValuesUpdateAction(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nullable List<T> newEnumValues, @Nonnull BiFunction<String, List<String>, UpdateAction<U>> removeEnumCallback) {
        Map newEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, Optional.ofNullable(newEnumValues).orElse(Collections.emptyList()));
        List keysToRemove = oldEnumValues.stream().map(WithKey::getKey).filter(oldEnumValueKey -> !newEnumValuesKeyMap.containsKey(oldEnumValueKey)).collect(Collectors.toList());
        return keysToRemove.isEmpty() ? Optional.empty() : Optional.of(removeEnumCallback.apply(definitionName, keysToRemove));
    }

    @Nonnull
    static <T extends WithKey, U> List<UpdateAction<U>> buildMatchingEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<T> oldEnumValues, @Nonnull List<T> newEnumValues, @Nonnull TriFunction<String, T, T, List<UpdateAction<U>>> matchingEnumCallback) {
        Map newEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, newEnumValues);
        return oldEnumValues.stream().filter(oldEnumValue -> newEnumValuesKeyMap.containsKey(oldEnumValue.getKey())).map(oldEnumValue -> (List)matchingEnumCallback.apply(definitionName, oldEnumValue, (WithKey)newEnumValuesKeyMap.get(oldEnumValue.getKey()))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static <T extends WithKey> Map<String, T> getEnumValuesKeyMapWithKeyValidation(@Nonnull String definitionName, @Nonnull List<T> enumValues) {
        return enumValues.stream().collect(Collectors.toMap(WithKey::getKey, enumValue -> enumValue, (enumValueA, enumValueB) -> {
            throw new DuplicateKeyException(String.format("Enum Values have duplicated keys. Definition name: '%s', Duplicated enum value: '%s'. Enum Values are expected to be unique inside their definition.", definitionName, enumValueA.getKey()));
        }));
    }

    private EnumValuesUpdateActionUtils() {
    }
}

