/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.queries.InventoryEntryQuery;
import io.sphere.sdk.inventory.queries.InventoryEntryQueryModel;
import io.sphere.sdk.queries.QueryPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public final class InventoryEntryQueryBuilder {
    private static final int MAX_QUERY_LENGTH = 10000;

    public static List<InventoryEntryQuery> buildQueries(@Nonnull Set<InventoryEntryIdentifier> identifiers) {
        if (identifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InventoryEntryQuery> inventoryEntryQueries = new ArrayList<InventoryEntryQuery>();
        StringBuilder queryBuilder = new StringBuilder();
        int limit = 0;
        for (InventoryEntryIdentifier identifier : identifiers) {
            String predicate = InventoryEntryQueryBuilder.buildQueryPredicate(identifier).toSphereQuery();
            if (queryBuilder.length() + predicate.length() > 10000) {
                inventoryEntryQueries.add(InventoryEntryQueryBuilder.getInventoryEntryQuery(queryBuilder, limit));
                queryBuilder.setLength(0);
                limit = 0;
            }
            queryBuilder.append("(");
            queryBuilder.append(predicate);
            queryBuilder.append(") or ");
            ++limit;
        }
        inventoryEntryQueries.add(InventoryEntryQueryBuilder.getInventoryEntryQuery(queryBuilder, limit));
        return inventoryEntryQueries;
    }

    private static InventoryEntryQuery getInventoryEntryQuery(@Nonnull StringBuilder queryBuilder, int limit) {
        String queryString = queryBuilder.substring(0, queryBuilder.length() - 4);
        return ((InventoryEntryQuery)io.sphere.sdk.inventory.queries.InventoryEntryQueryBuilder.of().plusPredicates(QueryPredicate.of((String)queryString)).build().withLimit((long)limit)).withFetchTotal(false);
    }

    private static QueryPredicate<InventoryEntry> buildQueryPredicate(@Nonnull InventoryEntryIdentifier identifier) {
        String sku = identifier.getSku();
        String supplyChannelId = identifier.getSupplyChannelId();
        InventoryEntryQueryModel queryModel = InventoryEntryQueryModel.of();
        return supplyChannelId == null ? queryModel.sku().is(sku).and(queryModel.supplyChannel().isNotPresent()) : queryModel.sku().is(sku).and(queryModel.supplyChannel().id().is(supplyChannelId));
    }

    private InventoryEntryQueryBuilder() {
    }
}

