/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.models.ResourceIdsGraphQlRequest;
import com.commercetools.sync.commons.models.ResourceKeyId;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.models.WithKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseTransformServiceImpl {
    public static final int CHUNK_SIZE = 300;
    public static final String KEY_IS_NOT_SET_PLACE_HOLDER = "KEY_IS_NOT_SET";
    protected final ReferenceIdToKeyCache referenceIdToKeyCache;
    private final SphereClient ctpClient;

    protected BaseTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        this.ctpClient = ctpClient;
        this.referenceIdToKeyCache = referenceIdToKeyCache;
    }

    protected SphereClient getCtpClient() {
        return this.ctpClient;
    }

    protected CompletableFuture<Void> fetchAndFillReferenceIdToKeyCache(@Nonnull Set<String> ids, @Nonnull GraphQlQueryResources requestType) {
        Set<String> nonCachedReferenceIds = this.getNonCachedReferenceIds(ids);
        if (nonCachedReferenceIds.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        List<List<String>> chunkedIds = ChunkUtils.chunk(nonCachedReferenceIds, 300);
        List<ResourceIdsGraphQlRequest> collectedRequests = this.createResourceIdsGraphQlRequests(chunkedIds, requestType);
        return ((CompletableFuture)ChunkUtils.executeChunks(this.getCtpClient(), collectedRequests).thenApply(ChunkUtils::flattenGraphQLBaseResults)).thenCompose(results -> {
            this.cacheResourceReferenceKeys((Set<ResourceKeyId>)results);
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    protected List<ResourceIdsGraphQlRequest> createResourceIdsGraphQlRequests(@Nonnull List<List<String>> chunkedIds, @Nonnull GraphQlQueryResources resourceType) {
        return chunkedIds.stream().map(chunk -> new ResourceIdsGraphQlRequest(new HashSet<String>((Collection<String>)chunk), resourceType)).collect(Collectors.toList());
    }

    @Nonnull
    protected Set<String> getNonCachedReferenceIds(@Nonnull Set<String> referenceIds) {
        return referenceIds.stream().filter(id -> !this.referenceIdToKeyCache.containsKey((String)id) || KEY_IS_NOT_SET_PLACE_HOLDER.equals(this.referenceIdToKeyCache.get((String)id))).collect(Collectors.toSet());
    }

    protected void cacheResourceReferenceKeys(Set<ResourceKeyId> results) {
        Optional.ofNullable(results).orElseGet(Collections::emptySet).forEach(resourceKeyId -> this.fillReferenceIdToKeyCache(resourceKeyId.getId(), resourceKeyId.getKey()));
    }

    protected <U extends Resource<U> & WithKey> void cacheResourceReferenceKeys(List<U> results) {
        Optional.ofNullable(results).orElseGet(Collections::emptyList).forEach(resource -> this.fillReferenceIdToKeyCache(resource.getId(), ((WithKey)resource).getKey()));
    }

    private void fillReferenceIdToKeyCache(String id, String key) {
        String keyValue = StringUtils.isBlank((CharSequence)key) ? KEY_IS_NOT_SET_PLACE_HOLDER : key;
        this.referenceIdToKeyCache.add(id, keyValue);
    }
}

