/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.helpers;

import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import io.sphere.sdk.shoppinglists.TextLineItemDraft;
import io.sphere.sdk.shoppinglists.TextLineItemDraftBuilder;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class TextLineItemReferenceResolver
extends CustomReferenceResolver<TextLineItemDraft, TextLineItemDraftBuilder, ShoppingListSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on TextLineItemDraft with name: '%s'.";

    public TextLineItemReferenceResolver(@Nonnull ShoppingListSyncOptions shoppingListSyncOptions, @Nonnull TypeService typeService) {
        super(shoppingListSyncOptions, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<TextLineItemDraft> resolveReferences(@Nonnull TextLineItemDraft textLineItemDraft) {
        return this.resolveCustomTypeReference(TextLineItemDraftBuilder.of((TextLineItemDraft)textLineItemDraft)).thenApply(TextLineItemDraftBuilder::build);
    }

    @Override
    @Nonnull
    protected CompletionStage<TextLineItemDraftBuilder> resolveCustomTypeReference(@Nonnull TextLineItemDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, TextLineItemDraftBuilder::getCustom, TextLineItemDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getName()));
    }
}

