/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.service.impl;

import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import com.commercetools.sync.states.service.StateTransformService;
import com.commercetools.sync.states.utils.StateReferenceResolutionUtils;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class StateTransformServiceImpl
extends BaseTransformServiceImpl
implements StateTransformService {
    public StateTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<StateDraft>> toStateDrafts(@Nonnull List<State> states) {
        return this.transformTransitionReference(states).thenApply(ignore -> StateReferenceResolutionUtils.mapToStateDrafts(states, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformTransitionReference(@Nonnull List<State> states) {
        Set<String> setOfTransitionStateIds = states.stream().map(State::getTransitions).filter(Objects::nonNull).map(transitions -> transitions.stream().filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(setOfTransitionStateIds, GraphQlQueryResources.STATES);
    }
}

