/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.taxcategories.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.taxcategories.utils.TaxRatesUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.taxcategories.TaxCategory;
import io.sphere.sdk.taxcategories.TaxCategoryDraft;
import io.sphere.sdk.taxcategories.commands.updateactions.ChangeName;
import io.sphere.sdk.taxcategories.commands.updateactions.SetDescription;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class TaxCategoryUpdateActionUtils {
    private TaxCategoryUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<UpdateAction<TaxCategory>> buildChangeNameAction(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTaxCategory.getName(), newTaxCategory.getName(), () -> ChangeName.of((String)newTaxCategory.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<TaxCategory>> buildSetDescriptionAction(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTaxCategory.getDescription(), newTaxCategory.getDescription(), () -> SetDescription.of((String)newTaxCategory.getDescription()));
    }

    @Nonnull
    public static List<UpdateAction<TaxCategory>> buildTaxRateUpdateActions(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        return TaxRatesUpdateActionUtils.buildTaxRatesUpdateActions(oldTaxCategory.getTaxRates(), newTaxCategory.getTaxRates());
    }
}

