/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.sync.commons.models.FetchCustomObjectsGraphQlRequest;
import com.commercetools.sync.commons.models.ResourceKeyId;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.client.NotFoundException;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.customobjects.CustomObject;
import io.sphere.sdk.customobjects.commands.CustomObjectDeleteCommand;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CleanupUnresolvedReferenceCustomObjects {
    private final SphereClient sphereClient;
    private final Statistics statistics;
    private int pageSize = 500;
    private Consumer<Throwable> errorCallback;

    private CleanupUnresolvedReferenceCustomObjects(@Nonnull SphereClient sphereClient) {
        this.sphereClient = sphereClient;
        this.statistics = new Statistics();
    }

    public static CleanupUnresolvedReferenceCustomObjects of(@Nonnull SphereClient sphereClient) {
        return new CleanupUnresolvedReferenceCustomObjects(sphereClient);
    }

    public CleanupUnresolvedReferenceCustomObjects errorCallback(@Nonnull Consumer<Throwable> errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    private void applyErrorCallback(@Nonnull Throwable exception) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(exception);
        }
    }

    public CleanupUnresolvedReferenceCustomObjects pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public CompletableFuture<Statistics> cleanup(int deleteDaysAfterLastModification) {
        return CompletableFuture.allOf(this.cleanupUnresolvedProductReferences(deleteDaysAfterLastModification), this.cleanupUnresolvedParentCategoryReferences(deleteDaysAfterLastModification), this.cleanupUnresolvedStateReferences(deleteDaysAfterLastModification)).thenApply(ignoredResult -> this.statistics);
    }

    private CompletableFuture<Void> cleanup(@Nonnull String containerName, int deleteDaysAfterLastModification) {
        Consumer pageConsumer = resourceKeyIds -> this.deleteCustomObjects(containerName, (Set<ResourceKeyId>)resourceKeyIds);
        return CtpQueryUtils.queryAll(this.sphereClient, this.getRequest(containerName, deleteDaysAfterLastModification), pageConsumer, this.pageSize).toCompletableFuture();
    }

    private CompletableFuture<Void> cleanupUnresolvedProductReferences(int deleteDaysAfterLastModification) {
        return this.cleanup("commercetools-sync-java.UnresolvedReferencesService.productDrafts", deleteDaysAfterLastModification);
    }

    private CompletableFuture<Void> cleanupUnresolvedParentCategoryReferences(int deleteDaysAfterLastModification) {
        return this.cleanup("commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", deleteDaysAfterLastModification);
    }

    private CompletableFuture<Void> cleanupUnresolvedStateReferences(int deleteDaysAfterLastModification) {
        return this.cleanup("commercetools-sync-java.UnresolvedTransitionsService.stateDrafts", deleteDaysAfterLastModification);
    }

    private FetchCustomObjectsGraphQlRequest getRequest(@Nonnull String containerName, int deleteDaysAfterLastModification) {
        Instant lastModifiedAt = Instant.now().minus(deleteDaysAfterLastModification, ChronoUnit.DAYS);
        return new FetchCustomObjectsGraphQlRequest(containerName, lastModifiedAt);
    }

    private void deleteCustomObjects(@Nonnull String containerName, @Nonnull Set<ResourceKeyId> resourceKeyIdSet) {
        CompletableFuture.allOf((CompletableFuture[])resourceKeyIdSet.stream().map(resourceKeyId -> this.executeDeletion(containerName, (ResourceKeyId)resourceKeyId)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)).join();
    }

    private CompletionStage<Optional<CustomObject<JsonNode>>> executeDeletion(@Nonnull String containerName, @Nonnull ResourceKeyId resourceKeyId) {
        return this.sphereClient.execute((SphereRequest)CustomObjectDeleteCommand.of((String)containerName, (String)resourceKeyId.getKey(), JsonNode.class)).handle(this::handleDeleteCallback);
    }

    private Optional<CustomObject<JsonNode>> handleDeleteCallback(@Nonnull CustomObject<JsonNode> resource, @Nullable Throwable throwable) {
        if (throwable == null) {
            this.statistics.totalDeleted.incrementAndGet();
            return Optional.of(resource);
        }
        if (throwable instanceof NotFoundException) {
            return Optional.empty();
        }
        this.applyErrorCallback(throwable);
        this.statistics.totalFailed.incrementAndGet();
        return Optional.empty();
    }

    public static class Statistics {
        final AtomicInteger totalDeleted = new AtomicInteger();
        final AtomicInteger totalFailed = new AtomicInteger();

        private Statistics() {
        }

        public int getTotalDeleted() {
            return this.totalDeleted.get();
        }

        public int getTotalFailed() {
            return this.totalFailed.get();
        }

        public String getReportMessage() {
            return String.format("Summary: %s custom objects were deleted in total (%s failed to delete).", this.getTotalDeleted(), this.getTotalFailed());
        }
    }
}

