/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.AssetActionFactory;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class AssetsUpdateActionUtils {
    public static final String ASSET_KEY_NOT_SET = "Asset with %s has no defined key. Keys are required for asset matching.";

    @Nonnull
    public static <T extends Resource, D> List<UpdateAction<T>> buildAssetsUpdateActions(@Nonnull D newResource, @Nonnull List<Asset> oldAssets, @Nullable List<AssetDraft> newAssetDrafts, @Nonnull AssetActionFactory<T, D> assetActionFactory, @Nonnull BaseSyncOptions syncOptions) throws BuildUpdateActionException {
        if (newAssetDrafts != null) {
            return AssetsUpdateActionUtils.buildAssetsUpdateActionsWithNewAssetDrafts(newResource, oldAssets, newAssetDrafts, assetActionFactory, syncOptions);
        }
        return oldAssets.stream().map(Asset::getKey).map(assetActionFactory::buildRemoveAssetAction).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    private static <T extends Resource, D> List<UpdateAction<T>> buildAssetsUpdateActionsWithNewAssetDrafts(@Nonnull D newResource, @Nonnull List<Asset> oldAssets, @Nonnull List<AssetDraft> newAssetDrafts, @Nonnull AssetActionFactory<T, D> assetActionFactory, @Nonnull BaseSyncOptions syncOptions) throws BuildUpdateActionException {
        HashSet<String> removedAssetKeys = new HashSet<String>();
        HashMap<String, Asset> oldAssetsKeyMap = new HashMap<String, Asset>();
        oldAssets.forEach(asset -> {
            String assetKey = asset.getKey();
            if (StringUtils.isNotBlank((CharSequence)assetKey)) {
                oldAssetsKeyMap.put(assetKey, (Asset)asset);
            } else {
                syncOptions.applyWarningCallback(new SyncException(String.format(ASSET_KEY_NOT_SET, "id: " + asset.getId())), asset, null);
            }
        });
        HashMap<String, AssetDraft> newAssetDraftsKeyMap = new HashMap<String, AssetDraft>();
        try {
            newAssetDrafts.forEach(newAsset -> {
                String assetKey = newAsset.getKey();
                if (StringUtils.isNotBlank((CharSequence)assetKey)) {
                    newAssetDraftsKeyMap.merge(assetKey, (AssetDraft)newAsset, (assetDraftA, assetDraftB) -> {
                        throw new DuplicateKeyException("Supplied asset drafts have duplicate keys. Asset keys are expected to be unique inside their container (a product variant or a category).");
                    });
                } else {
                    syncOptions.applyWarningCallback(new SyncException(String.format(ASSET_KEY_NOT_SET, "name: " + newAsset.getName())), null, newAsset);
                }
            });
        }
        catch (DuplicateKeyException exception) {
            throw new BuildUpdateActionException(exception);
        }
        List<UpdateAction<T>> updateActions = AssetsUpdateActionUtils.buildRemoveAssetOrAssetUpdateActions(newResource, oldAssets, removedAssetKeys, newAssetDraftsKeyMap, assetActionFactory);
        AssetsUpdateActionUtils.buildChangeAssetOrderUpdateAction(oldAssets, newAssetDrafts, removedAssetKeys, assetActionFactory).ifPresent(updateActions::add);
        updateActions.addAll(AssetsUpdateActionUtils.buildAddAssetUpdateActions(newAssetDrafts, oldAssetsKeyMap, assetActionFactory));
        return updateActions;
    }

    @Nonnull
    private static <T extends Resource, D> List<UpdateAction<T>> buildRemoveAssetOrAssetUpdateActions(@Nonnull D newResource, @Nonnull List<Asset> oldAssets, @Nonnull Set<String> removedAssetKeys, @Nonnull Map<String, AssetDraft> newAssetDraftsKeyMap, @Nonnull AssetActionFactory<T, D> assetActionFactory) {
        return oldAssets.stream().filter(asset -> StringUtils.isNotBlank((CharSequence)asset.getKey())).map(oldAsset -> {
            String oldAssetKey = oldAsset.getKey();
            AssetDraft matchingNewAssetDraft = (AssetDraft)newAssetDraftsKeyMap.get(oldAssetKey);
            return Optional.ofNullable(matchingNewAssetDraft).map(assetDraft -> assetActionFactory.buildAssetActions(newResource, (Asset)oldAsset, (AssetDraft)assetDraft)).orElseGet(() -> {
                removedAssetKeys.add(oldAssetKey);
                return Collections.singletonList(assetActionFactory.buildRemoveAssetAction(oldAssetKey));
            });
        }).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    private static <T extends Resource, D> Optional<UpdateAction<T>> buildChangeAssetOrderUpdateAction(@Nonnull List<Asset> oldAssets, @Nonnull List<AssetDraft> newAssetDrafts, @Nonnull Set<String> removedAssetKeys, @Nonnull AssetActionFactory<T, D> assetActionFactory) {
        Map<String, String> oldAssetKeyToIdMap = oldAssets.stream().filter(asset -> StringUtils.isNotBlank((CharSequence)asset.getKey())).collect(Collectors.toMap(Asset::getKey, Asset::getId));
        List newOrder = newAssetDrafts.stream().filter(asset -> StringUtils.isNotBlank((CharSequence)asset.getKey())).map(AssetDraft::getKey).map(oldAssetKeyToIdMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        List oldOrder = oldAssets.stream().filter(asset -> StringUtils.isNotBlank((CharSequence)asset.getKey())).filter(asset -> !removedAssetKeys.contains(asset.getKey())).map(Asset::getId).collect(Collectors.toList());
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldOrder, newOrder, () -> assetActionFactory.buildChangeAssetOrderAction(newOrder));
    }

    @Nonnull
    private static <T extends Resource, D> List<UpdateAction<T>> buildAddAssetUpdateActions(@Nonnull List<AssetDraft> newAssetDrafts, @Nonnull Map<String, Asset> oldAssetsKeyMap, @Nonnull AssetActionFactory<T, D> assetActionFactory) {
        ArrayList optionalActions = IntStream.range(0, newAssetDrafts.size()).mapToObj(assetDraftIndex -> Optional.ofNullable((AssetDraft)newAssetDrafts.get(assetDraftIndex)).filter(assetDraft -> StringUtils.isNotBlank((CharSequence)assetDraft.getKey()) && !oldAssetsKeyMap.containsKey(assetDraft.getKey())).map(assetDraft -> assetActionFactory.buildAddAssetAction((AssetDraft)assetDraft, assetDraftIndex))).collect(Collectors.toCollection(ArrayList::new));
        return OptionalUtils.filterEmptyOptionals(optionalActions);
    }

    private AssetsUpdateActionUtils() {
    }
}

