/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.exceptions.DuplicateNameException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.producttypes.utils.AttributeDefinitionUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.attributes.AttributeDefinition;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.EnumAttributeType;
import io.sphere.sdk.products.attributes.LocalizedEnumAttributeType;
import io.sphere.sdk.products.attributes.ReferenceAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.commands.updateactions.AddAttributeDefinition;
import io.sphere.sdk.producttypes.commands.updateactions.ChangeAttributeOrderByName;
import io.sphere.sdk.producttypes.commands.updateactions.RemoveAttributeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class AttributeDefinitionsUpdateActionUtils {
    @Nonnull
    static List<UpdateAction<ProductType>> buildAttributeDefinitionsUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nullable List<AttributeDefinitionDraft> newAttributeDefinitionsDrafts) throws BuildUpdateActionException {
        if (newAttributeDefinitionsDrafts != null) {
            return AttributeDefinitionsUpdateActionUtils.buildUpdateActions(oldAttributeDefinitions, newAttributeDefinitionsDrafts.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return oldAttributeDefinitions.stream().map(AttributeDefinition::getName).map(RemoveAttributeDefinition::of).collect(Collectors.toList());
    }

    @Nonnull
    private static List<UpdateAction<ProductType>> buildUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionsDrafts) throws BuildUpdateActionException {
        try {
            List<UpdateAction<ProductType>> updateActions = AttributeDefinitionsUpdateActionUtils.buildRemoveAttributeDefinitionOrAttributeDefinitionUpdateActions(oldAttributeDefinitions, newAttributeDefinitionsDrafts);
            updateActions.addAll(AttributeDefinitionsUpdateActionUtils.buildAddAttributeDefinitionUpdateActions(oldAttributeDefinitions, newAttributeDefinitionsDrafts));
            AttributeDefinitionsUpdateActionUtils.buildChangeAttributeDefinitionOrderUpdateAction(oldAttributeDefinitions, newAttributeDefinitionsDrafts).ifPresent(updateActions::add);
            return updateActions;
        }
        catch (DuplicateKeyException | DuplicateNameException | UnsupportedOperationException exception) {
            throw new BuildUpdateActionException(exception);
        }
    }

    @Nonnull
    private static List<UpdateAction<ProductType>> buildRemoveAttributeDefinitionOrAttributeDefinitionUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionsDrafts) {
        Map<String, AttributeDefinitionDraft> newAttributesDefinitionsDraftsNameMap = newAttributeDefinitionsDrafts.stream().collect(Collectors.toMap(AttributeDefinitionDraft::getName, attributeDefinitionDraft -> attributeDefinitionDraft, (attributeDefinitionDraftA, attributeDefinitionDraftB) -> {
            throw new DuplicateNameException(String.format("Attribute definitions drafts have duplicated names. Duplicated attribute definition name: '%s'. Attribute definitions names are expected to be unique inside their product type.", attributeDefinitionDraftA.getName()));
        }));
        return oldAttributeDefinitions.stream().map(oldAttributeDefinition -> {
            String oldAttributeDefinitionName = oldAttributeDefinition.getName();
            AttributeDefinitionDraft matchingNewAttributeDefinitionDraft = (AttributeDefinitionDraft)newAttributesDefinitionsDraftsNameMap.get(oldAttributeDefinitionName);
            return Optional.ofNullable(matchingNewAttributeDefinitionDraft).map(attributeDefinitionDraft -> {
                if (attributeDefinitionDraft.getAttributeType() != null) {
                    if (AttributeDefinitionsUpdateActionUtils.haveSameAttributeType(oldAttributeDefinition.getAttributeType(), matchingNewAttributeDefinitionDraft.getAttributeType())) {
                        return AttributeDefinitionUpdateActionUtils.buildActions(oldAttributeDefinition, attributeDefinitionDraft);
                    }
                    throw new UnsupportedOperationException(String.format("Due to eventual consistency of 'removeAttributeDefinition' action, changing the attribute definition type (attribute name='%s') is not supported programmatically. Please apply the attribute definition type changes manually through commercetools API or merchant center. For more information please check: https://github.com/commercetools/commercetools-sync-java/blob/master/docs/adr/0003-syncing-attribute-type-changes.md", oldAttributeDefinitionName));
                }
                return new ArrayList();
            }).orElseGet(() -> Collections.singletonList(RemoveAttributeDefinition.of((String)oldAttributeDefinitionName)));
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean haveSameAttributeType(@Nonnull AttributeType attributeTypeA, @Nonnull AttributeType attributeTypeB) {
        if (attributeTypeA instanceof SetAttributeType && attributeTypeB instanceof SetAttributeType) {
            return AttributeDefinitionsUpdateActionUtils.haveSameAttributeType(((SetAttributeType)attributeTypeA).getElementType(), ((SetAttributeType)attributeTypeB).getElementType());
        }
        if (attributeTypeA instanceof ReferenceAttributeType && attributeTypeB instanceof ReferenceAttributeType) {
            return ((ReferenceAttributeType)attributeTypeA).equalsIgnoreTypeRef((ReferenceAttributeType)attributeTypeB);
        }
        if (attributeTypeA instanceof EnumAttributeType && attributeTypeB instanceof EnumAttributeType) {
            return true;
        }
        if (attributeTypeA instanceof LocalizedEnumAttributeType && attributeTypeB instanceof LocalizedEnumAttributeType) {
            return true;
        }
        return Objects.equals(attributeTypeA, attributeTypeB);
    }

    @Nonnull
    private static Optional<UpdateAction<ProductType>> buildChangeAttributeDefinitionOrderUpdateAction(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionDrafts) {
        List newNames = newAttributeDefinitionDrafts.stream().map(AttributeDefinitionDraft::getName).collect(Collectors.toList());
        List existingNames = oldAttributeDefinitions.stream().map(AttributeDefinition::getName).filter(newNames::contains).collect(Collectors.toList());
        List notExistingNames = newNames.stream().filter(newName -> !existingNames.contains(newName)).collect(Collectors.toList());
        List newAttributeDefinitionsOrder = newAttributeDefinitionDrafts.stream().map(AttributeDefinitionDraft::getName).collect(Collectors.toList());
        List allNames = Stream.concat(existingNames.stream(), notExistingNames.stream()).collect(Collectors.toList());
        return CommonTypeUpdateActionUtils.buildUpdateAction(allNames, newNames, () -> ChangeAttributeOrderByName.of((List)newAttributeDefinitionsOrder));
    }

    @Nonnull
    private static List<UpdateAction<ProductType>> buildAddAttributeDefinitionUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionDrafts) {
        Map<String, AttributeDefinition> oldAttributeDefinitionNameMap = oldAttributeDefinitions.stream().collect(Collectors.toMap(AttributeDefinition::getName, attributeDefinition -> attributeDefinition));
        return newAttributeDefinitionDrafts.stream().filter(attributeDefinitionDraft -> !oldAttributeDefinitionNameMap.containsKey(attributeDefinitionDraft.getName())).map(AddAttributeDefinition::of).collect(Collectors.toList());
    }

    private AttributeDefinitionsUpdateActionUtils() {
    }
}

