/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import com.commercetools.sync.types.TypeSyncOptions;
import com.commercetools.sync.types.helpers.TypeBatchValidator;
import com.commercetools.sync.types.helpers.TypeSyncStatistics;
import com.commercetools.sync.types.utils.TypeSyncUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.TypeDraft;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TypeSync
extends BaseSync<TypeDraft, Type, TypeSyncStatistics, TypeSyncOptions> {
    private static final String CTP_TYPE_FETCH_FAILED = "Failed to fetch existing types with keys: '%s'.";
    private static final String CTP_TYPE_UPDATE_FAILED = "Failed to update type with key: '%s'. Reason: %s";
    private final TypeService typeService;
    private final TypeBatchValidator batchValidator;

    public TypeSync(@Nonnull TypeSyncOptions typeSyncOptions) {
        this(typeSyncOptions, new TypeServiceImpl(typeSyncOptions));
    }

    TypeSync(@Nonnull TypeSyncOptions typeSyncOptions, @Nonnull TypeService typeService) {
        super(new TypeSyncStatistics(), typeSyncOptions);
        this.typeService = typeService;
        this.batchValidator = new TypeBatchValidator((TypeSyncOptions)this.getSyncOptions(), (TypeSyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<TypeSyncStatistics> process(@Nonnull List<TypeDraft> typeDrafts) {
        List batches = SyncUtils.batchElements(typeDrafts, ((TypeSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture((TypeSyncStatistics)this.statistics));
    }

    @Override
    protected CompletionStage<TypeSyncStatistics> processBatch(@Nonnull List<TypeDraft> batch) {
        ImmutablePair<Set<TypeDraft>, Set<String>> result = this.batchValidator.validateAndCollectReferencedKeys(batch);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((TypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture((TypeSyncStatistics)this.statistics);
        }
        Set validTypeKeys = (Set)result.getRight();
        return this.typeService.fetchMatchingTypesByKeys(validTypeKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedTypes = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_TYPE_FETCH_FAILED, validTypeKeys);
                this.handleError(errorMessage, exception, null, null, null, validTypeKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(fetchedTypes, validDrafts);
        }).thenApply(ignored -> {
            ((TypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (TypeSyncStatistics)this.statistics;
        });
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<Type> oldTypes, @Nonnull Set<TypeDraft> newTypes) {
        Map oldTypeMap = oldTypes.stream().collect(Collectors.toMap(Type::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newTypes.stream().map(newType -> {
            Type oldType = (Type)oldTypeMap.get(newType.getKey());
            return Optional.ofNullable(oldType).map(type -> this.buildActionsAndUpdate(oldType, (TypeDraft)newType)).orElseGet(() -> this.applyCallbackAndCreate((TypeDraft)newType));
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Optional<Type>> applyCallbackAndCreate(@Nonnull TypeDraft typeDraft) {
        return ((TypeSyncOptions)this.syncOptions).applyBeforeCreateCallback(typeDraft).map(draft -> this.typeService.createType((TypeDraft)draft).thenApply(typeOptional -> {
            if (typeOptional.isPresent()) {
                ((TypeSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((TypeSyncStatistics)this.statistics).incrementFailed();
            }
            return typeOptional;
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    private CompletionStage<Optional<Type>> buildActionsAndUpdate(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        List updateActions = TypeSyncUtils.buildActions(oldType, newType, (TypeSyncOptions)this.syncOptions);
        List<UpdateAction<Type>> updateActionsAfterCallback = ((TypeSyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newType, oldType);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateType(oldType, newType, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Optional<Type>> updateType(@Nonnull Type oldType, @Nonnull TypeDraft newType, @Nonnull List<UpdateAction<Type>> updateActions) {
        return this.typeService.updateType(oldType, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Type updatedType = (Type)updateResponse.getKey();
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return TypeSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldType, newType), () -> {
                    String errorMessage = String.format(CTP_TYPE_UPDATE_FAILED, newType.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, oldType, newType, updateActions, 1);
                    return CompletableFuture.completedFuture(Optional.empty());
                });
            }
            ((TypeSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(Optional.of(updatedType));
        });
    }

    @Nonnull
    private CompletionStage<Optional<Type>> fetchAndUpdate(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        String key = oldType.getKey();
        return this.typeService.fetchType(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedTypeOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_TYPE_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, oldType, newType, null, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedTypeOptional.map(fetchedType -> this.buildActionsAndUpdate((Type)fetchedType, newType)).orElseGet(() -> {
                String errorMessage = String.format(CTP_TYPE_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, oldType, newType, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }
}

