/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.api;

import com.configcat.publicapi.java.client.ApiCallback;
import com.configcat.publicapi.java.client.ApiClient;
import com.configcat.publicapi.java.client.ApiException;
import com.configcat.publicapi.java.client.ApiResponse;
import com.configcat.publicapi.java.client.Configuration;
import com.configcat.publicapi.java.client.Pair;
import com.configcat.publicapi.java.client.model.AuditLogItemModel;
import com.configcat.publicapi.java.client.model.AuditLogType;
import com.configcat.publicapi.java.client.model.DeletedSettingModel;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class AuditLogsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuditLogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuditLogsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getAuditlogsCall(UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/auditlogs".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (configId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("configId", configId));
        }
        if (environmentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentId", environmentId));
        }
        if (auditLogType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auditLogType", (Object)auditLogType));
        }
        if (fromUtcDateTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromUtcDateTime", fromUtcDateTime));
        }
        if (toUtcDateTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("toUtcDateTime", toUtcDateTime));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuditlogsValidateBeforeCall(UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getAuditlogs(Async)");
        }
        return this.getAuditlogsCall(productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime, _callback);
    }

    public List<AuditLogItemModel> getAuditlogs(UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime) throws ApiException {
        ApiResponse<List<AuditLogItemModel>> localVarResp = this.getAuditlogsWithHttpInfo(productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime);
        return localVarResp.getData();
    }

    public ApiResponse<List<AuditLogItemModel>> getAuditlogsWithHttpInfo(UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime) throws ApiException {
        Call localVarCall = this.getAuditlogsValidateBeforeCall(productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime, null);
        Type localVarReturnType = new TypeToken<List<AuditLogItemModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAuditlogsAsync(UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime, ApiCallback<List<AuditLogItemModel>> _callback) throws ApiException {
        Call localVarCall = this.getAuditlogsValidateBeforeCall(productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime, _callback);
        Type localVarReturnType = new TypeToken<List<AuditLogItemModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeletedSettingsCall(UUID configId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/configs/{configId}/deleted-settings".replace("{configId}", this.localVarApiClient.escapeString(configId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeletedSettingsValidateBeforeCall(UUID configId, ApiCallback _callback) throws ApiException {
        if (configId == null) {
            throw new ApiException("Missing the required parameter 'configId' when calling getDeletedSettings(Async)");
        }
        return this.getDeletedSettingsCall(configId, _callback);
    }

    public List<DeletedSettingModel> getDeletedSettings(UUID configId) throws ApiException {
        ApiResponse<List<DeletedSettingModel>> localVarResp = this.getDeletedSettingsWithHttpInfo(configId);
        return localVarResp.getData();
    }

    public ApiResponse<List<DeletedSettingModel>> getDeletedSettingsWithHttpInfo(UUID configId) throws ApiException {
        Call localVarCall = this.getDeletedSettingsValidateBeforeCall(configId, null);
        Type localVarReturnType = new TypeToken<List<DeletedSettingModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeletedSettingsAsync(UUID configId, ApiCallback<List<DeletedSettingModel>> _callback) throws ApiException {
        Call localVarCall = this.getDeletedSettingsValidateBeforeCall(configId, _callback);
        Type localVarReturnType = new TypeToken<List<DeletedSettingModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrganizationAuditlogsCall(UUID organizationId, UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/organizations/{organizationId}/auditlogs".replace("{organizationId}", this.localVarApiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (productId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("productId", productId));
        }
        if (configId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("configId", configId));
        }
        if (environmentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentId", environmentId));
        }
        if (auditLogType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auditLogType", (Object)auditLogType));
        }
        if (fromUtcDateTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromUtcDateTime", fromUtcDateTime));
        }
        if (toUtcDateTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("toUtcDateTime", toUtcDateTime));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrganizationAuditlogsValidateBeforeCall(UUID organizationId, UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime, ApiCallback _callback) throws ApiException {
        if (organizationId == null) {
            throw new ApiException("Missing the required parameter 'organizationId' when calling getOrganizationAuditlogs(Async)");
        }
        return this.getOrganizationAuditlogsCall(organizationId, productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime, _callback);
    }

    public List<AuditLogItemModel> getOrganizationAuditlogs(UUID organizationId, UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime) throws ApiException {
        ApiResponse<List<AuditLogItemModel>> localVarResp = this.getOrganizationAuditlogsWithHttpInfo(organizationId, productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime);
        return localVarResp.getData();
    }

    public ApiResponse<List<AuditLogItemModel>> getOrganizationAuditlogsWithHttpInfo(UUID organizationId, UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime) throws ApiException {
        Call localVarCall = this.getOrganizationAuditlogsValidateBeforeCall(organizationId, productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime, null);
        Type localVarReturnType = new TypeToken<List<AuditLogItemModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrganizationAuditlogsAsync(UUID organizationId, UUID productId, UUID configId, UUID environmentId, AuditLogType auditLogType, OffsetDateTime fromUtcDateTime, OffsetDateTime toUtcDateTime, ApiCallback<List<AuditLogItemModel>> _callback) throws ApiException {
        Call localVarCall = this.getOrganizationAuditlogsValidateBeforeCall(organizationId, productId, configId, environmentId, auditLogType, fromUtcDateTime, toUtcDateTime, _callback);
        Type localVarReturnType = new TypeToken<List<AuditLogItemModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

