/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.api;

import com.configcat.publicapi.java.client.ApiCallback;
import com.configcat.publicapi.java.client.ApiClient;
import com.configcat.publicapi.java.client.ApiException;
import com.configcat.publicapi.java.client.ApiResponse;
import com.configcat.publicapi.java.client.Configuration;
import com.configcat.publicapi.java.client.Pair;
import com.configcat.publicapi.java.client.model.ConfigModel;
import com.configcat.publicapi.java.client.model.CreateConfigRequest;
import com.configcat.publicapi.java.client.model.UpdateConfigRequest;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class ConfigsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ConfigsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConfigsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createConfigCall(UUID productId, CreateConfigRequest createConfigRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateConfigRequest localVarPostBody = createConfigRequest;
        String localVarPath = "/v1/products/{productId}/configs".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createConfigValidateBeforeCall(UUID productId, CreateConfigRequest createConfigRequest, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling createConfig(Async)");
        }
        if (createConfigRequest == null) {
            throw new ApiException("Missing the required parameter 'createConfigRequest' when calling createConfig(Async)");
        }
        return this.createConfigCall(productId, createConfigRequest, _callback);
    }

    public ConfigModel createConfig(UUID productId, CreateConfigRequest createConfigRequest) throws ApiException {
        ApiResponse<ConfigModel> localVarResp = this.createConfigWithHttpInfo(productId, createConfigRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ConfigModel> createConfigWithHttpInfo(UUID productId, CreateConfigRequest createConfigRequest) throws ApiException {
        Call localVarCall = this.createConfigValidateBeforeCall(productId, createConfigRequest, null);
        Type localVarReturnType = new TypeToken<ConfigModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createConfigAsync(UUID productId, CreateConfigRequest createConfigRequest, ApiCallback<ConfigModel> _callback) throws ApiException {
        Call localVarCall = this.createConfigValidateBeforeCall(productId, createConfigRequest, _callback);
        Type localVarReturnType = new TypeToken<ConfigModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteConfigCall(UUID configId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/configs/{configId}".replace("{configId}", this.localVarApiClient.escapeString(configId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteConfigValidateBeforeCall(UUID configId, ApiCallback _callback) throws ApiException {
        if (configId == null) {
            throw new ApiException("Missing the required parameter 'configId' when calling deleteConfig(Async)");
        }
        return this.deleteConfigCall(configId, _callback);
    }

    public void deleteConfig(UUID configId) throws ApiException {
        this.deleteConfigWithHttpInfo(configId);
    }

    public ApiResponse<Void> deleteConfigWithHttpInfo(UUID configId) throws ApiException {
        Call localVarCall = this.deleteConfigValidateBeforeCall(configId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteConfigAsync(UUID configId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteConfigValidateBeforeCall(configId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getConfigCall(UUID configId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/configs/{configId}".replace("{configId}", this.localVarApiClient.escapeString(configId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getConfigValidateBeforeCall(UUID configId, ApiCallback _callback) throws ApiException {
        if (configId == null) {
            throw new ApiException("Missing the required parameter 'configId' when calling getConfig(Async)");
        }
        return this.getConfigCall(configId, _callback);
    }

    public ConfigModel getConfig(UUID configId) throws ApiException {
        ApiResponse<ConfigModel> localVarResp = this.getConfigWithHttpInfo(configId);
        return localVarResp.getData();
    }

    public ApiResponse<ConfigModel> getConfigWithHttpInfo(UUID configId) throws ApiException {
        Call localVarCall = this.getConfigValidateBeforeCall(configId, null);
        Type localVarReturnType = new TypeToken<ConfigModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getConfigAsync(UUID configId, ApiCallback<ConfigModel> _callback) throws ApiException {
        Call localVarCall = this.getConfigValidateBeforeCall(configId, _callback);
        Type localVarReturnType = new TypeToken<ConfigModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getConfigsCall(UUID productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/configs".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getConfigsValidateBeforeCall(UUID productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getConfigs(Async)");
        }
        return this.getConfigsCall(productId, _callback);
    }

    public List<ConfigModel> getConfigs(UUID productId) throws ApiException {
        ApiResponse<List<ConfigModel>> localVarResp = this.getConfigsWithHttpInfo(productId);
        return localVarResp.getData();
    }

    public ApiResponse<List<ConfigModel>> getConfigsWithHttpInfo(UUID productId) throws ApiException {
        Call localVarCall = this.getConfigsValidateBeforeCall(productId, null);
        Type localVarReturnType = new TypeToken<List<ConfigModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getConfigsAsync(UUID productId, ApiCallback<List<ConfigModel>> _callback) throws ApiException {
        Call localVarCall = this.getConfigsValidateBeforeCall(productId, _callback);
        Type localVarReturnType = new TypeToken<List<ConfigModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateConfigCall(UUID configId, UpdateConfigRequest updateConfigRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateConfigRequest localVarPostBody = updateConfigRequest;
        String localVarPath = "/v1/configs/{configId}".replace("{configId}", this.localVarApiClient.escapeString(configId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateConfigValidateBeforeCall(UUID configId, UpdateConfigRequest updateConfigRequest, ApiCallback _callback) throws ApiException {
        if (configId == null) {
            throw new ApiException("Missing the required parameter 'configId' when calling updateConfig(Async)");
        }
        if (updateConfigRequest == null) {
            throw new ApiException("Missing the required parameter 'updateConfigRequest' when calling updateConfig(Async)");
        }
        return this.updateConfigCall(configId, updateConfigRequest, _callback);
    }

    public ConfigModel updateConfig(UUID configId, UpdateConfigRequest updateConfigRequest) throws ApiException {
        ApiResponse<ConfigModel> localVarResp = this.updateConfigWithHttpInfo(configId, updateConfigRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ConfigModel> updateConfigWithHttpInfo(UUID configId, UpdateConfigRequest updateConfigRequest) throws ApiException {
        Call localVarCall = this.updateConfigValidateBeforeCall(configId, updateConfigRequest, null);
        Type localVarReturnType = new TypeToken<ConfigModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateConfigAsync(UUID configId, UpdateConfigRequest updateConfigRequest, ApiCallback<ConfigModel> _callback) throws ApiException {
        Call localVarCall = this.updateConfigValidateBeforeCall(configId, updateConfigRequest, _callback);
        Type localVarReturnType = new TypeToken<ConfigModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

